\name{getEdges.ggobi}
\alias{getEdges.ggobi}
\alias{setEdges.ggobi}
\title{Connections between points in a GGobi dataset}
\description{
  These functions allow the user to establish and query
  connections between points in a GGobi instance
  and use this information to show edge connections
  on displays.
}
\usage{
getEdges.ggobi(.data=1, .gobi=getDefaultGGobi())
setEdges.ggobi(x, y, append=T, .data=1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{.data}{an identifier for the dataset within the GGobi instance,
    given as an index or an object of class the \code{ggobiDataset}}
  \item{.gobi}{an identifier for the GGobi instance which can be
    omitted if \code{.data} is a \code{ggobiDataset} object.
    Otherwise this should be an integer identifying the GGobi instance
    or a \code{ggobi} object.
  }
  \item{x}{a vector identifying the source of the edges
    by index or a 2 column matrix giving the source and destination}
  \item{y}{a vector giving the indeces of the destination nodes of the
    edges used together with \code{x}
  }
  \item{append}{a logical value indicating whether to add these to the
    dataset or to replace the existing connections with these.}
}
\details{
}
\value{
 A matrix giving the edge pairs before the call.
}
\references{
\url{http://www.ggobi.org}
}
\author{
Duncan Temple Lang
}
\note{
  The edge mechanism in GGobi is very powerful
  and supports a very general form of linking.
  As a result, simple uses may appear complex.
  The idea with this interface is to try to hide the complexity.
  However, you are advised to read the GGobi and RGGobi manuals
  to get a better understanding of edges and  linking.
}

\seealso{
  \code{\link{createEdgeData.ggobi}}
  \code{\link{setDisplayEdges.ggobi}}
}

\examples{


}
\keyword{dynamic}
