\name{getCurrentDisplayType.ggobi}
\alias{getCurrentDisplayType.ggobi}
\title{Get the active ggobi display type.}
\description{
 Returns a string describing the type of the 
currently active display in the specified 
ggobi instance.
}
\usage{
getCurrentDisplayType.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{.gobi}{the ggobi instance identifier.}
}
\details{
 At any time, a ggobi instance has a single display or plot window
that is active and within that, a plot on which operations (e.g. brushing)
can be performed. This is the active plot.
}
\value{
 A string (character vector of length $1$) giving
the plot type.
The possible types can be retrieved via the function
\code{\link{getViewTypes.ggobi}}.
Currently these are 
 \code{"Parallel Coordinates"},
 \code{"Scatterplot"} and \code{"Scatterplot Matrix"}.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{getDisplays.ggobi}}
\code{\link{getDefaultGGobi}}
\code{\link{getViewTypes.ggobi}}
}

\examples{

}
\keyword{visualization}
\keyword{graphics}
