\name{getDescription.ggobi}
\alias{getDescription.ggobi}
\title{A brief description of a ggobi instance}
\description{
 This returns a brief version of the ggobi instance description,
giving the name of the file and mode of the data source
and the dimensions of the first dataset.
This is brief in contrast to the more complete
description provided by \code{\link{describe.ggobi}}.
}
\usage{
getDescription.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{.gobi}{the identifier for the ggobi instance being queried.}
}
\value{
 A list with three elements:
  \item{Filename}{ the name of the primary input file from which the data was read.
   If the data was given directly from R, this is the description value supplied
   at theat time.}
  \item{Data mode}{the format in which the data was presented to ggobi.}
  \item{Data dimensions}{the number of records and variables in the dataset.}
  ... 
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
 \code{\link{describe.ggobi}}
 \code{\link{getGGobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  g$getDescription()
}
\keyword{visualization}
\keyword{interactive graphics}
