\name{getDisplayCount.ggobi}
\alias{getDisplayCount.ggobi}
\title{The number of displays within a ggobi instance.}
\description{
 This function yields the number of displays,
or plot windows, within a particular ggobi instance.
}
\usage{
getDisplayCount.ggobi(.gobi=getDefaultGGobi())
}
\arguments{
  \item{.gobi}{the identifier for the ggobi instance whose
    displays are to be queried.}
}
\value{
A single integer value giving the number of display
windows that are currently open.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
\code{\link{getDisplays.ggobi}}
}
\examples{
 g <- ggobi(system.file("data", "sat.xml", package="Rggobi"), args="-noinit")
 g$scatmat(1:3)
 g$getDisplayCount()

 g$parcoords(c("tars1", "tars2"))
 g$getDisplayCount()
}
\keyword{visualization}
\keyword{interactive graphics}
