\name{getGGobi}
\alias{getGGobi}
\title{Returns a ggobi reference}
\description{
 This allows one to get a list of all the ggobi
 instances currently in existence in the R session.
 Also, one can fetch particular instances. 
 This function returns objects of class \code{ggobi}
 which can the be used as the \code{.gobi} argument
 in the different function calls, and also
 for invoking these functions in a more convenient
 form, i.e.
  \code{names(g)}
 Additionally, these are returned as objects of class
reference
 It is most convenient to call the ggobi functions 
}
\usage{
getGGobi(...)
}
\arguments{
  \item{\dots}{identifiers, typically integers, identifying
  which ggobi instances are to be returned. If no values are 
  specified, a list of all the ggobi instances is returned.
  }
}
\value{
 A list of the ggobi instances identified by the
 \code{\dots} arguments.
 Each element is an object of class \code{ggobi}.
 If there is a single argument, the list is collapsed
 and the single object of class \code{ggobi} is returned.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
 \code{\link{getDefaultGGobi}}
 \code{names.ggobi}
 \code{$.ggobi}
}

\examples{
  ggobi(system.file("data", "sat.xml", package="Rggobi"), args="-noinit")
  g <- getGGobi()
  if(!is.null(g)) {
    if(!inherits(g, "ggobi"))
       g <- g[[1]]
    names(g)
    g$getColors()
    getColors.ggobi(.gobi = g)
  }
}
\keyword{visualization}
\keyword{interactive graphics}
