\name{getGlyphTypes.ggobi}
\alias{getGlyphTypes.ggobi}
\alias{getGlyphSizes.ggobi}
\title{Get the names and sizes of ggobi's available glyphs for displaying points in a plot.}
\description{
 These functions allow one to query the names (and internal codes)
 and possible sizes of the glyphs that ggobi understands and can
 use to display points on a plot.
}
\usage{
getGlyphTypes.ggobi()
getGlyphSizes.ggobi()
}
\value{
\code{getGlyphTypes.ggobi} A named integer vector containing the 
internal ggobi glyph identifier, indexed by its external name representation.

\code{getGlyphTypes.ggobi} An integer vector giving
the possible sizes that one can specify for a glyph.
}
}
\references{\url{http://www.ggobi.org/RSggobi.html}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{getGlyphs.ggobi}}
}

\examples{
  getGlyphTypes.ggobi()

  g <- ggobi(system.file("data","flea.xml", package="Rggobi"), args="-noinit")
  g$setGlyphs(max(getGlyphSizes.ggobi()))
}
\keyword{visualization}
\keyword{interactive graphics}

