\name{getVariableNames.ggobi}
\alias{getVariableNames.ggobi}
\alias{setVariableNames.ggobi}
\title{Variable names of a ggobi dataset}
\description{
 This sets or retrieves the names of the 
variables within a ggobi dataset.
}
\usage{
getVariableNames.ggobi(tform=F, .data = 1, .gobi=getDefaultGGobi())
setVariableNames.ggobi(..., .data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{tform}{a logical value indicating whether the
names of the transformed variables (\code{TRUE}) or the regular names (\code{FALSE})
are to be returned.
}
  \item{.data}{the identifier for the dataset the name of whose variables
 are to be returned. This can be an object of class \code{ggobiDataset},
 the name of the dataset (returned by \code{names.ggobi})
or an integer index. }
  \item{.gobi}{The identifier for the ggobi instance in which to find the
dataset. This should be an object of class \code{ggobi} or alternatively
an integer identifying the ggobi instance by order. See \code{getDefaultGGobi},
\code{getGGobi} and \code{getNumGGobis}.}
  \item{...}{a collection of \code{name=value} pairs giving the current name of
  a variable and its new name in the form \code{current=new}}
}
\details{
 This resolves the ggobi instance, then the dataset and
returns the variable names.
}
\value{
 A character vector containing the names of the variables
in the specifid dataset.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{dimnames.ggobiDataset}
\code{colnames.ggobiDataset}
\code{names.ggobi}
}

\examples{
  g <- ggobi(system.file("data","flea.xml", package="Rggobi"), args="-noinit")

   # Use the default ggobi and dataset
  getVariableNames.ggobi()

  getVariableNames.ggobi(.data = g[1])

  dimnames(g[1])[[2]]  
  colnames(g[1])  
  names(g[1])


  g$setData(system.file("data", "sat.xml", package="Rggobi"), add=T)
  getVariableNames.ggobi(.data="SAT scores")
}
\keyword{visualization}
\keyword{interactive graphics}
