\name{ggobiDataset accesors}
\alias{$.ggobiDataset}
\title{Shorthand for calling ggobi functions with a given dataset.}
\description{
 Many functions in this package operate on a dataset within
 a ggobi instance. This function provides a convenient syntax for
invoking such functions by keying off a reference to a dataset (i.e. a
\code{ggobiDataset} object) which identifies both the dataset and
the ggobi instance. 
}
\usage{
"$.ggobiDataset"(d, name)
}
\arguments{
  \item{d}{ the object of class \code{ggobiDataset} which identifies
  both the ggobi instance and specific dataset within it.}
  \item{name}{the name of the function to be accessed with this
 dataset and ggobi instance.}
}
\value{
 A closure instance that is a function which 
 calls the function \textit{name}\code{.ggobi}
 with the \code{.data} argument given by this 
 data set object and \code{.ggobi} argument given
 by the \code{.ggobi} field of that \code{ggobiDataset} instance.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
 \code{\link{$.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  d <- g[1]
  d$getColors()
  g[1]$getGlyphs()
  
  g[1]$setColors(rep(2,20), 1:20) # or use a color name.
}
\keyword{visualization}
\keyword{interactive graphics}
