\name{setDisplayOptions.ggobi}
\alias{setDisplayOptions.ggobi}
\alias{getDisplayOptions.ggobi}
\title{Controls the basic display settings for ggobi}
\description{
 This allows one to set the settings that control
how ggobi displays its plots.
These have effect on all plots created after the settings
have been registered, and are not applied to existing plots.
}
\usage{
getDisplayOptions.ggobi(which=1, .gobi=getDefaultGGobi())
setDisplayOptions.ggobi(points, directed, undirected, segments, missings, axes, display, .gobi=getDefaultGGobi())
}
\arguments{
  \item{which}{the identifier for the display of interest, either an index
   or a \code{ggobiDisplay} object.}
  \item{display}{the display identifier, either an integer giving the index in the list of displays
   within the GGobi instance, or an object of class \code{ggobiDisplay}}
  \item{points}{logical value indicating whether points are to be displayed on a plot.}
  \item{directed}{logical value indicating whether the line segments are to be shown as directed 
(TRUE) or undirected (FALSE) line segments.}
  \item{undirected}{}
  \item{segments}{}
  \item{missings}{}
  \item{axes}{whether axes should be displayed with the plot or not.}
  \item{.gobi}{the ggobi instance for which the settings are to be applied.}
}

\value{
 The previous settings that were in effect 
before this call.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{getDisplayOptions.ggobi}}
}

\examples{
 # untested

 data(mtcars)
 ggobi(mtcars)

 old <- setDisplayOptions.ggobi(axes=FALSE)
 scatterplot.ggobi("mpg", "am")

   # restore the old settings.
 setDisplayOptions.ggobi(old)
}
\keyword{visualization}
