\name{setIdentifyHandler.ggobi}
\alias{setIdentifyHandler.ggobi}
\title{Register callback for ggobi point identification}
\description{
This function  is an example of how we can link R
commands into ggobi and have ggobi ``notify''
R of certain events. 
This  example allows us to register an R function
that is called each time an observation is selected
in ggobi's ``identify'' mode, i.e. when the label appears
over the point. This R function is given information
about the point being identified,
a description of the display in which the identification
is being performed, and  the index of the active plot.
This gives a programmatic version of \code{\link{locator}}.
}
\usage{
setIdentifyHandler.ggobi(f, .gobi=getDefaultGGobi())
}
\arguments{
  \item{f}{the function to be invoked when 
    an observation is identified by the interactive ggobi
   selection/identification mechanism.
  This currently should take two arguments which are 
  the index of the observation just identified, and the
  display object (of class \code{ggobiDisplay}) which identifies the 
  window and ggobi instance in which the identification was made.}
  \item{.gobi}{the ggobi instance with which the function should be registered
   and within which identification of a record triggers the callback.}
}
\details{
 This is just an illustration of how we can connect
the functionality in the two environments (R and ggobi).
We can add other function callbacks and event notifications
to provide more interactivity at the R level.
}
\value{
The previously registered value of 
this callback function.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
\code{\link{setSmootherFunction.ggobi}}
\code{\link{locator}}
}

\examples{
 f <- function(id, display) {
    print(id)
    print(display)
 }
 g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
 g$setIdentifyHandler(f)
 g$setMode("Identify")
  # now move the mouse over some of the points
}
\keyword{visualization}
\keyword{interactive graphics}
