\name{setVariableValues.ggobi}
\alias{setVariableValues.ggobi}
\alias{setVariableName.ggobi}
\title{Set variable information in a ggobi dataset.}
\description{
 These functions allow one to set the values or name of
one or more variables within a ggobi dataset.
}
\usage{
setVariableValues.ggobi(values, var, rows = 1:length(values), update = T, .data = 1, .gobi=getDefaultGGobi())
setVariableNames.ggobi(..., .data = 1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{values}{a numeric vector of values which are to be used
    as the values for the specified variable.}
  \item{var}{an identifier for the variable whose values are to be
    replaced with those in \code{values}. This can be either a
   name or alternatively an integer identifying the variable by index.}
  \item{rows}{the indices of the rows whose values are to be set.
    The i-th element of values becomes the value
    of the rows[i] element of the specified variable.}
  \item{update}{whether to update the displays after setting the values.
  Typicaly this is TRUE. However, if one wanted to set values
  for other variables after this, one can delay the update operation
  until all changes are complete.}
  \item{\dots}{a collection of named string arguments
     of the form \code{existingName = newName}
     specifying the mapping from an existing name to
     the new name that is to replace it.
    }
  \item{.data}{the identifier for the dataset in which the variable(s) reside.}
  \item{.gobi}{the ggobi instance.}
}
\value{
\code{setVariableNames.ggobi} returns the previous settings
for the names of those variables that were modified.

\code{setVariableValues.ggobi} returns the previous values for the
records/observations in the specified variable.

}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\note{\code{setVariable.ggobi} and \code{setVariableValues.ggobi}
appear to be very similar. That probably means that a) one will disappear
and b) one is not tested as comprehensively as the other.}

\seealso{
\code{\link{setDataFrame.ggobi}}
\code{\link{names.ggobiDataset}}
\code{\link{getVariable.ggobi}}
}

\examples{
 g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
 g$setVariableNames(tars1="New name", aede1="Other name")

   # Set all the values of the tars1 variable to `1'.
 g$setVariableValues(rep(1, 74), rows = 1:74, var = "tars1")

   # Set the first 23 values. 
 g$setVariableValues(rnorm(23), var = "tars1")


}
\keyword{visualization}
\keyword{interactive graphics}
