\name{writeDataXML}
\alias{writeDataXML}
\title{Write one or more datasets in GGobi's XML format}
\description{
  This creates an XML output object (to a buffer, DOM, ...)
  containing a description of a collection of datasets
  using GGobi's data format.
}
\usage{
writeDataXML(..., dom = xmlOutputDOM("ggobidata", attrs = c(count = length(args))))
}

\arguments{
  \item{\dots}{one or more datasets, typically given as
    \code{name=object} so that the `name' is used in the XML
    description.
  }
  \item{dom}{the XML output object to which to write/append the XML
    description. This is usuall an object of class \code{XMLOutputStream}}
}
\details{
  The GGobi data format is described in the GGobi documentation
  and may be used in other projects and contexts.
  It is reasonably simply, consisting of a top-level
  \code{ggobidata} node with an (optional) attribute indicating the
  number of datasets it contains, and then each dataset described as
  sub-nodes. Each dataset consists of a top-level \code{data} node
  with \code{name} attribute. Within this, we have
  an optional \code{description} node giving a human-readable
  description of the dataset, where it came from, etc.
  Next is a \code{variables} node which details each of the variables,
  giving its type (currently either as a \code{realvariable}
  or \code{categoricalvariable}) and any other information, such
  as its name and its levels.
  
}
\value{
  The \code{dom} object is returned, presumably with its state
  changed to include the XML for the datasets.
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
  \code{addXMLDataset}
}

\examples{
 data(mtcars)
 dd <- writeXMLData(mtcars = mtcars)
 cat(dd$value())
}
\keyword{visualization}
\keyword{interactive graphics}
