#include "RSGGobi.h"

/**
  This gets and sets the colorschemes in a GGobi instance or
  the session options.
 */
USER_OBJECT_ RSGGobi_Internal_getColorSchemes(GList *schemes);
USER_OBJECT_ RSGGobi_Internal_getColorScheme(colorschemed *scheme);
USER_OBJECT_ RSGGobi_Internal_getColor(gfloat *vals, colorscaletype type, int n);
colorschemed *RS_createGGobiScheme(USER_OBJECT_ colors, USER_OBJECT_ bg, USER_OBJECT_ annotations, 
				   USER_OBJECT_ type, USER_OBJECT_ name);

gfloat *RS_setGGobiColor(USER_OBJECT_ colors);

static GList *
RSGGobi_Internal_getSchemeFromGGobi(USER_OBJECT_ gobiId)
{
    GList *schemes = NULL;
    if(GET_LENGTH(gobiId)) {
	ggobid *gg;
	gg = GetGGobi(gobiId);

	if(!gg) {
	    PROBLEM "invalid GGobi object"
		ERROR;
	}

	schemes = gg->colorSchemes;
    } else {
	if(sessionOptions)
	    schemes = sessionOptions->colorSchemes;
	else {
          PROBLEM "GGobi has not been initialized yet. Please create an instance!"
	      ERROR;
	}
    }

    return(schemes);
}

USER_OBJECT_
RS_GGOBI(getColorSchemes)(USER_OBJECT_ gobiId)
{
    GList *schemes;

    schemes = RSGGobi_Internal_getSchemeFromGGobi(gobiId);

    return(RSGGobi_Internal_getColorSchemes(schemes));
}

USER_OBJECT_
RSGGobi_Internal_getColorSchemes(GList *schemes)
{
    int i, n;
    USER_OBJECT_ ans, names;
    colorschemed *s;

    n = g_list_length(schemes);
    PROTECT(ans = NEW_LIST(n));
    PROTECT(names = NEW_CHARACTER(n));

    for(i = 0; i < n ; i++) {
	s = (colorschemed *) g_list_nth_data(schemes, i);
	SET_STRING_ELT(names, i, COPY_TO_USER_STRING(s->name));
	SET_VECTOR_ELT(ans, i, RSGGobi_Internal_getColorScheme(s));
    }

    SET_NAMES(ans, names);
    UNPROTECT(2);
    return(ans);
}


USER_OBJECT_
RSGGobi_Internal_getColorScheme(colorschemed *scheme)
{
    USER_OBJECT_ ans, tmp, names;
    char *slotNames[] = {"colors", "background", "annotations", "criticalvalue"};
    int i, n, numSlots = sizeof(slotNames)/sizeof(slotNames[0]);

    PROTECT(ans = NEW_LIST(numSlots));

    n = scheme->n;
    PROTECT(names = NEW_CHARACTER(n));
    PROTECT(tmp = NEW_LIST(n));
    for(i = 0; i < n; i++) {
	SET_VECTOR_ELT(tmp, i, RSGGobi_Internal_getColor(scheme->data[i], scheme->type, 3));
	SET_STRING_ELT(names, i, COPY_TO_USER_STRING(g_array_index(scheme->colorNames, gchar *, i)));
    }
    SET_NAMES(tmp, names);
    SET_VECTOR_ELT(ans, 0, tmp);

    SET_VECTOR_ELT(ans, 1, RSGGobi_Internal_getColor(scheme->bg, scheme->type, 3));
    SET_VECTOR_ELT(ans, 2, RSGGobi_Internal_getColor(scheme->accent, scheme->type, 3));


    PROTECT(names = NEW_CHARACTER(numSlots));
    for(i = 0; i < numSlots; i++) {
	SET_STRING_ELT(names, i, COPY_TO_USER_STRING(slotNames[i]));
    }
    SET_NAMES(ans, names);

    UNPROTECT(4);
    return(ans);
}

USER_OBJECT_ 
RSGGobi_Internal_getColor(gfloat *vals, colorscaletype type, int n)
{
    USER_OBJECT_ ans, tmp, names;
    char *slotNames[] = {"red", "green", "blue"};
    int i;

    PROTECT(ans = NEW_LIST(n));
    PROTECT(names = NEW_CHARACTER(n));
    for(i = 0; i < n;i++) {
	SET_VECTOR_ELT(ans, i, tmp = NEW_NUMERIC(1));
	NUMERIC_DATA(tmp)[0] = vals[i];
	SET_STRING_ELT(names, i, COPY_TO_USER_STRING(slotNames[i]));
    }
    SET_NAMES(ans, names);

    UNPROTECT(2);
    return(ans);
}



USER_OBJECT_
RS_GGOBI(addColorScheme)(USER_OBJECT_ colors, USER_OBJECT_ bg, USER_OBJECT_ annotations, USER_OBJECT_  type, USER_OBJECT_ name, USER_OBJECT_ overwrite, USER_OBJECT_ gobiId)
{
    USER_OBJECT_ ans;
    int index = 0;
    colorschemed *scheme;
    GList *schemes = RSGGobi_Internal_getSchemeFromGGobi(gobiId);

    scheme = RS_createGGobiScheme(colors, bg, annotations, type, name);


       /* Perhaps we need to inform the Color scheme tool if it is open,
          and add it to the tree. Similarly, if we set the active scheme from
          R, we should tell everybody that might be interested. */
    if(LOGICAL_DATA(overwrite)[0]) {
	/* */
	GList *tmp = schemes;
/*	g_list_find_custom(); */
    } else {
	schemes = g_list_append(schemes, scheme);
	index = g_list_length(schemes);
    }

    ans = NEW_INTEGER(1);
    INTEGER_DATA(ans)[0] = index;
    return(ans);
}

colorschemed *
RS_createGGobiScheme(USER_OBJECT_ colors, USER_OBJECT_ bg, USER_OBJECT_ annotations, 
                      USER_OBJECT_ type, USER_OBJECT_ name)
{
 colorschemed *scheme;
 int n, i;
 USER_OBJECT_ colorNames;
 char *str;
 gchar *gstr;

 scheme = alloc_colorscheme(sizeof(colorschemed));
 if(!scheme) {
  PROBLEM "Cannot allocate space for color scheme"
  ERROR;
 }

 scheme->type = INTEGER_DATA(type)[0];

 scheme->name = g_strdup(CHAR_DEREF(STRING_ELT(name, 0)));

 scheme->n = n = GET_LENGTH(colors);
 colorNames = GET_NAMES(colors);
 scheme->data = (gfloat **) g_malloc(sizeof(gfloat *) * n);
 for(i = 0; i < n; i++) {
    if(GET_LENGTH(colorNames) && (str = CHAR_DEREF(STRING_ELT(colorNames, i)))) {
	gstr = g_strdup(str);
	g_array_append_val(scheme->colorNames, gstr);
    }
    scheme->data[i] = RS_setGGobiColor(VECTOR_ELT(colors, i));  
 }

 if(GET_LENGTH(bg))
     scheme->bg = RS_setGGobiColor(bg);
 if(GET_LENGTH(annotations))
     scheme->accent = RS_setGGobiColor(annotations);

 return(scheme);
}


gfloat *
RS_setGGobiColor(USER_OBJECT_ colors)
{
    int j, numVals;
    gfloat *data;
    numVals = GET_LENGTH(colors);
    data = g_malloc(sizeof(gfloat) * numVals);
    for(j = 0; j < numVals ; j++) {
	data[j] = NUMERIC_DATA(VECTOR_ELT(colors, j))[0];
    }

    return(data);
}

static int
schemeNameCompare(gconstpointer scheme, gconstpointer data)
{
    return(strcmp(((colorschemed *)scheme)->name, (char *)data));
}

USER_OBJECT_
RS_GGOBI(setActiveColorScheme)(USER_OBJECT_ id, USER_OBJECT_ gobiId)
{
    USER_OBJECT_ ans;
    char *tmp = NULL;
    GList *schemes;
    ggobid *gg = NULL;
    colorschemed *newScheme = NULL;

    if(GET_LENGTH(gobiId) == 0) {
	if(sessionOptions) {
	    tmp = sessionOptions->activeColorScheme;
	    sessionOptions->activeColorScheme = g_strdup(CHAR_DEREF(STRING_ELT(id, 0)));
	} else {
          PROBLEM "GGobi has not been initialized yet. Please create an instance!"
	      ERROR;
	}
    } else {
	gg = GetGGobi(gobiId);
	schemes = RSGGobi_Internal_getSchemeFromGGobi(gobiId);

	if(!schemes) {
	    PROBLEM "Cannot get color schemes list"
		ERROR;
	}

	if(gg->activeColorScheme)
	    tmp = gg->activeColorScheme->name;

	if(IS_INTEGER(id)) {
	   GList *el = g_list_nth(schemes, INTEGER_DATA(id)[0]);
	   newScheme = gg->activeColorScheme = (colorschemed *) el->data;
	} else if(IS_CHARACTER(id)) {
	    char *tmp = CHAR_DEREF(STRING_ELT(id, 0));
	    GList *el = g_list_find_custom(schemes, tmp, schemeNameCompare);
	    newScheme = gg->activeColorScheme = (colorschemed *) el->data;
	}

	if(newScheme) {
	    datad *d = (datad *) g_slist_nth_data(gg->d, 0);
	    colorscheme_init(newScheme);
	    displays_plot (NULL, FULL, gg);
	    symbol_window_redraw (gg);
	    cluster_table_update (d, gg);
	    gdk_flush();
	}
    }

    if(tmp) {
	PROTECT(ans = NEW_CHARACTER(1));
	SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(sessionOptions->activeColorScheme ? sessionOptions->activeColorScheme : ""));
	UNPROTECT(1);
    } else
	ans = NULL_USER_OBJECT;


    return(ans);
}
