/*
  R & S routines for retrieving the current settings
 */

#include "RSGGobi.h"

#include <gtk/gtk.h>

#include "vars.h"

#include "RUtils.h"

USER_OBJECT_ RS_GGOBI(getBrushColor)(USER_OBJECT_ ggobiId);


/*
  Returns the names of the datasets within the specified
  ggobid object.
 */
USER_OBJECT_
RS_GGOBI(getDatasetNames)(USER_OBJECT_ gobiId)
{
  USER_OBJECT_ ans;
  ggobid *gg = GetGGobi(gobiId);  
  int i;
  datad *d;
  GSList *tmp = gg->d;
  int n = g_slist_length(gg->d);

  PROTECT(ans = NEW_CHARACTER(n));
  for(i = 0; i < n ; i++) {
    d =(datad *) tmp->data;
    SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(d->name));
    tmp = tmp->next;
  }

  UNPROTECT(1);
  return(ans);
}


USER_OBJECT_
RS_GGOBI(getVariableNames)(USER_OBJECT_ transformed, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d = NULL;

  d = resolveDatad(datasetId, ggobiId, NULL);

  if(d)
    return(RS_INTERNAL_GGOBI(getVariableNames)(d));
  else
    return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_INTERNAL_GGOBI(getVariableNames)(datad *d)
{
  USER_OBJECT_ ans;
  gint n, i;
  vartabled *vt;

  n =  d->ncols;
  PROTECT(ans = NEW_CHARACTER(n));

  for (i = 0; i < n ; i++) {
    vt = vartable_element_get(i, d);
    SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(vt->collab));
  }

  UNPROTECT(1);

  return(ans);
}


USER_OBJECT_
RS_GGOBI(getData)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d;
 USER_OBJECT_ ans, rownames, colnames, dims;
 gint nr, nc;
 gint i, j;
 vartabled *vt;

 d = resolveDatad(datasetId, ggobiId, NULL);
 if(d) {

   nr = d->nrows;
   nc = d->ncols;
 
   if(nr == 0 || nc == 0)
       return(NULL_USER_OBJECT);

    PROTECT(ans = allocMatrix(REALSXP, nr, nc));
    PROTECT(dims = NEW_LIST(2));
   
    PROTECT(rownames = NEW_CHARACTER(nr));
    PROTECT(colnames = NEW_CHARACTER(nc));
    SET_VECTOR_ELT(dims, 0, rownames);
    SET_VECTOR_ELT(dims, 1, colnames);
   
    for (i =0; i < nr; i++) {
      SET_STRING_ELT(rownames, i, 
   	COPY_TO_USER_STRING ((gchar *) g_array_index (d->rowlab, gchar *, i)));
   
      for (j =0; j < nc; j++) {
   	if (i == 0) {
          vt = vartable_element_get(j, d);
   	  SET_STRING_ELT(colnames, j, COPY_TO_USER_STRING(vt->collab));
   	}
        if(d->missing.vals[i][j])
  	   NUMERIC_DATA(ans)[i + j*nr] = NA_REAL;
        else
      	   NUMERIC_DATA(ans)[i + j*nr] = d->raw.vals[i][j];
      }
    }
     
    SET_DIMNAMES(ans, dims);
   
    UNPROTECT(4);
 } else
   ans = NULL_USER_OBJECT;

 return (ans);
}





USER_OBJECT_
RS_GGOBI(getSelectedIndices)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d;
 USER_OBJECT_ ans, names;

  d = resolveDatad(datasetId, ggobiId, NULL);
  if(d) {
   gint nr, i, ctr;
   gchar *name;
       nr = d->npts_under_brush;
       
       if (nr < 1)
      	 return(NULL_USER_OBJECT);
      	
       PROTECT(ans = NEW_INTEGER(nr));
       PROTECT(names = NEW_CHARACTER(nr));
       ctr = 0;
       for(i = 0 ; i < d->nrows ; i++) {
      	 if (d->pts_under_brush.els[i]) {
           INTEGER_DATA(ans)[ctr] = i + 1; /* Make these 1 based */
           name = (gchar *) g_array_index (d->rowlab, gchar *, i);
           if(name && name[0]) 
             SET_STRING_ELT(names, ctr, COPY_TO_USER_STRING (name));
           ctr++;
      	 }
       }
       
       SET_NAMES(ans, names);
       UNPROTECT(2);
   } else 
     ans = NULL_USER_OBJECT;

 return (ans);
}

USER_OBJECT_
RS_GGOBI(getRowNames)(USER_OBJECT_ data, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  gint nr, i;
  datad *d;
  if(R_IS(data, "ggobiDataset")) {
    d = GetDatad(data);
  } else if(IS_INTEGER(data)) {
    ggobid *gg = GetGGobi(ggobiId);
    if(gg) {
      d = (datad *) g_slist_nth_data (gg->d, INTEGER_DATA(data)[0]);
    }
  }

  if(d) {
    nr = d->nrows;
    PROTECT(ans = NEW_CHARACTER(nr));

    for (i = 0 ; i < nr ; i++) {
      SET_STRING_ELT(ans, i,
      COPY_TO_USER_STRING ((gchar *) g_array_index (d->rowlab, gchar *, i)));
    }
    UNPROTECT(1);
  }

  return (ans);
}

USER_OBJECT_
RS_GGOBI(getRowColors)(USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  datad *d;
  USER_OBJECT_ ans;
  gint nr, i;

  if (g_slist_length (gg->d) == 1)
    d = (datad *) g_slist_nth_data (gg->d, 0);
  nr = d->nrows;

  PROTECT(ans = NEW_INTEGER(nr));

  for (i = 0; i < nr ; i++) {
    INTEGER_DATA(ans)[i] = d->color_now.els[i];
  }

  UNPROTECT(1);

  return (ans);
}


USER_OBJECT_
RS_GGOBI(getSelectedVariables)(USER_OBJECT_ ggobiId)
{
  /*ggobid *gg = GetGGobi(ggobiId);*/
  USER_OBJECT_ ans, names;
  gint numVars; /* Depends on the type of plot currently active. */
  gint i;

  numVars = 1;

  PROTECT(ans = NEW_CHARACTER(numVars));
  PROTECT(names = NEW_CHARACTER(numVars));

  for (i = 0; i < numVars; i++) {

  }

  UNPROTECT(2);

  return (ans);
}


USER_OBJECT_
RS_GGOBI(getConnectedEdges)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
 datad *d = resolveDatad(datasetId, ggobiId, NULL);
 gint i, ctr; 
 USER_OBJECT_ ans, dim;
 gint n = d->edge.n;

 ans = NEW_INTEGER(n * 2);
 PROTECT(ans);

 ctr = 0;
#ifdef OLD_STYLE_IDS
 for(i = 0; i < n; i++) {
   INTEGER_DATA(ans)[ctr] = d->edge.old_endpoints[i].a; 
   INTEGER_DATA(ans)[ctr+n] = d->edge.old_endpoints[i].b; 
   ctr++;
 }
#endif

 /* Now set the dim() on this vector to make it a matrix. 
    The S code will put the dimnames on it.
  */
 PROTECT(dim = NEW_INTEGER(2));
  INTEGER_DATA(dim)[0] = n;
  INTEGER_DATA(dim)[1] = 2;
  SET_DIM(ans, dim);
 UNPROTECT(2);

 return(ans);
}


USER_OBJECT_
RS_GGOBI(getRgroups)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{

  USER_OBJECT_ ans = NULL_USER_OBJECT;
  datad *d;
 
  d = resolveDatad(datasetId, ggobiId, NULL);

  if(d) {
    gint i;

    PROTECT(ans = NEW_INTEGER(d->nrows_in_plot));

    for(i = 0; i < d->nrows_in_plot ; i++) {
      INTEGER_DATA(ans)[i] = d->rows_in_plot.els[i];
    }

    UNPROTECT(1);
  }

  return (ans);
}



USER_OBJECT_
RS_GGOBI(setRgroups)(USER_OBJECT_ rowIds, USER_OBJECT_ datasetId, USER_OBJECT_ gobiId)
{
  gint i;
  datad *d;
  USER_OBJECT_ ans = NEW_LOGICAL(1);

  d = resolveDatad(datasetId, gobiId, NULL);
  if(d) {
    int num = GET_LENGTH(rowIds);
       /* Why do we free this? Can't we just reuse it, or does it have
          the wrong length? Weird if it does, as we don't seem to reset 
          the length. 
        */
/*
 *  if (d->rows_in_plot)
 *    g_free(d->rows_in_plot);
 *  d->rows_in_plot = (gint *) g_malloc(sizeof(gint)*d->nrows_in_plot);
*/
    /* dfs: not sure what the intention is in this function ... */
    vectori_realloc (&d->rows_in_plot, d->nrows);

    for (i = 0; i < num ; i++) {
      d->rows_in_plot.els[i] = INTEGER_DATA(rowIds)[i];
    }
    LOGICAL_DATA(ans)[0] = TRUE;
  }

  return(ans);
}



USER_OBJECT_
RS_GGOBI(getColorMap)(USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans;
  static const gchar *const ColorNames[]={"Red", "Green", "Blue"};
  ggobid *gg = GetGGobi(ggobiId);
  const gchar *colorName;
  USER_OBJECT_ cnames, rnames, dm;
  colorschemed *scheme = gg->activeColorScheme;
  gint nr = scheme->n, i;

#ifdef _R_
  PROTECT(ans = allocMatrix(REALSXP, nr, 3));
#else
#error "Add code to allocate a matrix here"
#endif

  PROTECT(rnames = NEW_CHARACTER(nr));
  for(i = 0; i < nr; i++) {
    NUMERIC_DATA(ans)[i] = scheme->rgb[i].red;
    NUMERIC_DATA(ans)[nr + i] = scheme->rgb[i].green;
    NUMERIC_DATA(ans)[2*nr + i] = scheme->rgb[i].blue;
    colorName = GGOBI(getColorName)(i, gg, true);
    if(colorName && colorName[0])
      SET_STRING_ELT(rnames, i, COPY_TO_USER_STRING(colorName));
  }

  PROTECT(cnames = NEW_CHARACTER(3));
  for(i = 0; i < 3; i++)
   SET_STRING_ELT(cnames, i, COPY_TO_USER_STRING(ColorNames[i]));

  PROTECT(dm = NEW_LIST(2));
  SET_VECTOR_ELT(dm, 0, rnames);
  SET_VECTOR_ELT(dm, 1, cnames);
  SET_DIMNAMES(ans, dm);
  UNPROTECT(4);

 return(ans);
}


USER_OBJECT_
RS_GGOBI(setColorMap)(USER_OBJECT_ vals, USER_OBJECT_ names, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);

  GGOBI(setColorMap)(NUMERIC_DATA(vals), GET_LENGTH(vals)/3, gg);
  if(GET_LENGTH(names)) {
          
  }
  
  return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_GGOBI(setMode)(USER_OBJECT_ name, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
    GGOBI(setMode)((const gchar *) CHAR_DEREF(STRING_ELT(name,0)), gg);
    /* Trying to get the main window updated so that the changes to the control
       panel are visible without having to move the mouse into the window to generate
       another event. */
    gtk_widget_queue_draw(gg->main_window);
    gtk_widget_queue_draw(gg->control_panel[IDENT]);
/*    gtk_widget_draw(gg->main_window); */
  }
  
  gdk_flush();

  return(NULL_USER_OBJECT);
}

USER_OBJECT_
RS_GGOBI(getModeName)(USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans;
  const gchar *tmp;
  ggobid *gg = GetGGobi(ggobiId);
  tmp = GGOBI(getModeName)(viewmode_get(gg));

  PROTECT(ans = NEW_CHARACTER(1));
  if(tmp && tmp[0])
    SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(tmp));
  UNPROTECT(1);
  return(ans);
}

USER_OBJECT_
RS_GGOBI(setBrushColor)(USER_OBJECT_ cid, USER_OBJECT_ ggobiId)
{
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
   ans = RS_GGOBI(getBrushColor)(ggobiId);
   (void) GGOBI(setBrushColor)(INTEGER_DATA(cid)[0], gg);
   brush_reset(gg, 0);
   gdk_flush();
  }

 return(ans);
}

USER_OBJECT_
RS_GGOBI(getBrushColor)(USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
    USER_OBJECT_ ans;
    gint cid;

     cid =  GGOBI(getBrushColor)(gg);
     PROTECT(ans = NEW_INTEGER(1));
     INTEGER_DATA(ans)[0] = cid;
     SET_NAMES(ans, RS_INTERNAL_GGOBI(getColorName)(cid, gg));
     UNPROTECT(1);
    return(ans);
  } else
    return(NULL);
}

USER_OBJECT_
RS_INTERNAL_GGOBI(getColorName)(gint cid, ggobid *gg)
{
  USER_OBJECT_ name;
  const gchar *colName;
    PROTECT(name = NEW_CHARACTER(1));
    colName = GGOBI(getColorName)(cid, gg, false);
    if(colName)
      SET_STRING_ELT(name, 0, COPY_TO_USER_STRING(colName));
    UNPROTECT(1);
  return(name);
}

USER_OBJECT_
RS_GGOBI(setBrushGlyph)(USER_OBJECT_ vals, USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  if(gg) {
    GGOBI(setBrushGlyph)(INTEGER_DATA(vals)[0], INTEGER_DATA(vals)[1], gg);
    brush_reset(gg, 0);
    gdk_flush();
  }
 return(NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(getBrushGlyph)(USER_OBJECT_ ggobiId)
{
  gint t, s;
  ggobid *gg;
  USER_OBJECT_ ans;
  gg = GetGGobi(ggobiId);
  if(gg) {
   GGOBI(getBrushGlyph)(&t, &s, gg);
   ans = NEW_INTEGER(2);
   INTEGER_DATA(ans)[0] = t;
   INTEGER_DATA(ans)[1] = s;
  } else
    ans = NULL_USER_OBJECT;

  return(ans);
}


USER_OBJECT_
RS_GGOBI(setCasesHidden)(USER_OBJECT_ vals, USER_OBJECT_ which, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint i;
  ggobid *gg;
  datad *d;
  USER_OBJECT_ ans = NEW_LOGICAL(1);
  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d) {
    int num = GET_LENGTH(vals);
    for (i = 0; i < num; i++) {
      GGOBI(setCaseHidden)(INTEGER_DATA(which)[i], LOGICAL_DATA(vals)[i], d, gg);
    }

   displays_plot (NULL, FULL, gg);
   gdk_flush();
   LOGICAL_DATA(ans)[0] = TRUE;
  }

  return(ans);
}



USER_OBJECT_
RS_GGOBI(getCasesHidden)(USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint num, i;
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  ggobid *gg;
  datad *d;
  d = resolveDatad(datasetId, ggobiId,  &gg);
    if(d) {
      num = d->nrows, i;

      PROTECT(ans = NEW_LOGICAL(num));
      for(i = 0; i < num; i++) {
        LOGICAL_DATA(ans)[i] = GGOBI(getCaseHidden)(i, d, gg);
      }

      UNPROTECT(1);
    }

  return(ans);
}




USER_OBJECT_
RS_GGOBI(addVariable)(USER_OBJECT_ vals, USER_OBJECT_ name, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  datad *d;
  ggobid *gg;
  USER_OBJECT_ ans = NULL_USER_OBJECT;
  d = resolveDatad(datasetId, ggobiId, &gg);

  if(d) {
    ans = NEW_INTEGER(1);
    INTEGER_DATA(ans)[0] = GGOBI(addVariable)(NUMERIC_DATA(vals),
      GET_LENGTH(vals), CHAR_DEREF(STRING_ELT(name,0)), true, d, gg);
  }

  return(ans);
}

USER_OBJECT_
RS_GGOBI(setVariableValues)(USER_OBJECT_ vals, USER_OBJECT_ rowIds,
                             USER_OBJECT_ colId, USER_OBJECT_ update, 
                               USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  ggobid *gg;
  datad *d;
  gint i, num, var, row;
  
  d = resolveDatad(datasetId, ggobiId, &gg);

  num = GET_LENGTH(rowIds);
  var = INTEGER_DATA(colId)[0];
  for (i=0;i < num; i++) {
    row = INTEGER_DATA(rowIds)[i];
    d->raw.vals[row][var] = d->tform.vals[row][var] = NUMERIC_DATA(vals)[i];
  }

/*  splot_reverse_pipeline (gg->current_splot, row, &gg->movepts.eps, true, true, gg); */
  /*
   * This call does too much. Need to find a routine that does
   * just what is needed.

  pipeline_init (d, gg);
  displays_plot(NULL, FULL, gg);

  */
  if(LOGICAL_DATA(update)[0]) {
      tform_to_world (d, gg);
      displays_tailpipe (FULL, gg);
      gdk_flush();
  }

  return(NULL_USER_OBJECT);
}


USER_OBJECT_
RS_GGOBI(setVariableNames)(USER_OBJECT_ vars, USER_OBJECT_ names, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{
  gint i, which;
  ggobid *gg;
  datad *d;
  int num = GET_LENGTH(vars);
  gchar **curNames; 
  USER_OBJECT_ ans;

  d = resolveDatad(datasetId, ggobiId, &gg);
  if(d == NULL)
    return(NULL_USER_OBJECT);

  PROTECT(ans = NEW_CHARACTER(num));
  curNames = GGOBI(getVariableNames)(false, d, gg);
  for (i = 0; i < num; i++) {
    which = INTEGER_DATA(vars)[i];
    SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(curNames[which]));
    GGOBI(setVariableName)(which, CHAR_DEREF(STRING_ELT(names,i)), false, d, gg);
    GGOBI(setVariableName)(which, CHAR_DEREF(STRING_ELT(names,i)), true, d, gg);
  }

  UNPROTECT(1);
  return(ans);
}

USER_OBJECT_
RS_GGOBI(raiseOrLowerDisplays)(USER_OBJECT_ displays, USER_OBJECT_ iconify, USER_OBJECT_ raise, USER_OBJECT_ ggobiId)
{
    USER_OBJECT_ ans;
    int numDisplays = GET_LENGTH(displays), i;

    if(numDisplays == 0)
	return(NULL_USER_OBJECT);

    PROTECT(ans = NEW_LOGICAL(numDisplays));

    for(i = 0; i < numDisplays; i++) {
      displayd *display;
      windowDisplayd *wdpy;
      display = GetDisplay(VECTOR_ELT(displays, i), ggobiId, NULL);
      if(display == NULL || GTK_IS_GGOBI_WINDOW_DISPLAY(display) == false)
	  continue;

      wdpy = GTK_GGOBI_WINDOW_DISPLAY(display);

      if(LOGICAL_DATA(iconify)[0] == FALSE) {
        if(LOGICAL_DATA(raise)[0]) 
          gdk_window_raise(wdpy->window->window); 
        else
          gdk_window_lower(wdpy->window->window); 
      } else {
          /* This doesn't seem to iconify things, just kill them! 
             XIconifyWindow(GDK_WINDOW_XDISPLAY(GTK_WIDGET(window)->window),
                             GDK_WINDOW_XWINDOW(GTK_WIDGET(window)->window),
                             DefaultScreen (GDK_DISPLAY ()));             
           */
        if(LOGICAL_DATA(raise)[0]) 
          gtk_widget_show_all(wdpy->window); 
        else
          gtk_widget_hide_all(wdpy->window); 
      }

      LOGICAL_DATA(ans)[i] = TRUE;
    }

    UNPROTECT(1);

    gdk_flush();
    return(ans);
}

/**
 Probably should be deprecated.
 */
void
RS_GGOBI(raiseDisplay)(glong *plotId, glong *numEls, glong *raiseOrIcon,
  glong *up, glong *ggobiId)
{
  ggobid *gg = ggobi_get(*ggobiId);
  gint i;

  for (i = 0; i < *numEls; i++) {
    plotId[i] = GGOBI(raiseWindow)(plotId[i], raiseOrIcon[0], up[0], gg);
  }
}


USER_OBJECT_
RS_GGOBI(getVariable)(int which, datad *d)
{
    int nr = d->nrows, i;
    USER_OBJECT_ ans;
    vartabled *vt;
     vt = vartable_element_get (which, d);

     if(vt->vartype == categorical) {
       PROTECT(ans = NEW_INTEGER(nr));
     } else {
       PROTECT(ans = NEW_NUMERIC(nr));
     }
    for(i = 0; i < nr; i++) {
        float f = d->raw.vals[i][which];
    if(vt->vartype == categorical)
	    INTEGER_DATA(ans)[i] = f;
        else
	    NUMERIC_DATA(ans)[i] = f;
    }
    if(vt->vartype == categorical) {
        USER_OBJECT_ levs;
        nr = vt->nlevels;
        PROTECT(levs = NEW_CHARACTER(nr));
	for(i = 0; i < nr; i++) {
          gchar* tmp;
          tmp = (gchar *) vt->level_names[i];
	  SET_STRING_ELT(levs, i, COPY_TO_USER_STRING(tmp));
	}
        SET_LEVELS(ans, levs);
        PROTECT(levs = NEW_CHARACTER(1));
        SET_STRING_ELT(levs, 0, COPY_TO_USER_STRING("factor"));
        SET_CLASS(ans, levs);
	UNPROTECT(2);
    }

    UNPROTECT(1);
    return(ans);
}

USER_OBJECT_
RS_GGOBI(getVariables)(USER_OBJECT_ which, USER_OBJECT_ datasetId, USER_OBJECT_ ggobiId)
{

  datad *d = NULL;
  USER_OBJECT_ ans = NULL_USER_OBJECT;

  d = resolveDatad(datasetId, ggobiId, NULL);

  if(d) {
      int n = GET_LENGTH(which), i;
 
      PROTECT(ans = NEW_LIST(n));

      for(i = 0; i < n; i++) {
	  SET_VECTOR_ELT(ans, i, RS_GGOBI(getVariable)(INTEGER_DATA(which)[i]-1, d));
      }
      UNPROTECT(1);
  } else {
   PROBLEM "Cannot identify dataset in GGobi"
   ERROR;
  }

  return(ans);
}



