\name{ggobi accessors}
\alias{$.ggobi}
\title{Convenience accessor for calling ggobi methods}
\description{
 Most of the functions in this ggobi package act on a ggobi
instance. The \code{$} operator allows one to treat these functions as
method calls on the instance, in the form of \code{g$method}.  This
allows one to explicitly indicate which ggobi instance is being used
and also to avoid typing the \code{.ggobi} suffix for the different
functions.
}
\usage{
"$.ggobi"(x, name)
}
\arguments{
  \item{x}{the ggobi instance in the form of an object of class  \code{ggobi}.}
  \item{name}{the name of the function to be invoked, without the 
  \code{.ggobi} suffix.}
}
\value{
 This creates a closure which ``remembers'' the 
\code{ggobi} instance \code{g} and returns a function
which will call the function named  \textit{name}\code{.ggobi}
with that \code{ggobi} object as the named argument
\code{.gobi}. 
This is then called directly and its return value
rarely stored for future computations.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}
\seealso{
 \code{\link{$.ggobi}}
All functions that take a \code{.gobi} argument
and are named \code{*.ggobi}.
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"))
  g$getDisplays()
  g$getDisplayCount()
  g$getDatasetReference(1) # g[[1]]
}
\concept{visualization}
\concept{interactive graphics}
\keyword{classes}
