/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Fernando Nasser
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.explain;

import java.awt.*;
import javax.swing.*;

/**
 * An event that indicates that something important in a Explain
 * component has occurred. It is generated by Explain
 * object. Currently, the only events that can occur are running and idle.
 *
 * @author <a href="mailto:fnasser@redhat.com">Fernando nasser</a>
 * @version 0.0
 */
public class ExplainEvent extends AWTEvent {

	public static final int EXPLAIN_EVENT = 
		AWTEvent.RESERVED_ID_MAX + 5434;
		
	/** ID that indicates what event has occurred. */
	private String event_id;
	
	/** Exception received by source. */
	private Exception exception;

	/**
	 * Creates a new <code>ExplainEvent</code> instance.
	 *
	 * @param source a <code>Explain</code> value
	 * @param id an <code>int</code> value
	 */
	public ExplainEvent(JComponent source, String id)
	{
		super(source, EXPLAIN_EVENT);
		event_id = id;
	}

	/**
	 * Creates a new <code>ExplainEvent</code> instance
	 * for cases where an exception was encountered..
	 *
	 * @param source a <code>Explain</code> value
	 * @param id an <code>int</code> value
	 * @param ex exception received by source
	 */
	public ExplainEvent(JComponent source, String id, Exception ex)
	{
		super(source, EXPLAIN_EVENT);
		event_id = id;
		exception = ex;
	}
	
	public String getStatus() {
		return event_id;
	}
	
	public Exception getException() {
		return exception;
	}
	
}// ExplainEvent
