///// Common System functions ////////////

#include "rtsystem.h"
#include "rtstring.h"

namespace lrt {

String Time::months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", 
						  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

Time Time::operator-(const Time& t)
{
	Time ret;
	ret.sec = sec - t.sec;
	ret.msec = msec - t.msec;
	if(ret.msec < 0) {
		ret.msec += 1000;
		ret.sec--;
	}
	return ret;
}

int Time::toInt()
{
	return sec * 1000 + msec;
}

int Time::getMonthNum(const String& monthName)
{
	for(int i = 0; i < 12; i++)
		if(monthName == months[i])
			return i;
	System::println("warning: unrecognized month name: " + monthName);
	return 0;
}


////////////////// System ///////////////////

System::BreakFunction System::lastBreakFunction = 0;

void System::exit()
{
	System::exit(0);
}

void System::exit(int code, const char* msg)
{
	System::exit(code, String(msg));
}

//////////////// Console stuff ///////////

bool System::init = false;
bool System::interactive = true;
String* System::appName = new String("LibRT");

void System::setAppName(const String& appName)
{
	delete System::appName;
	System::appName = 0;
	System::appName = new String(appName);
}

void System::setInteractive(bool val)
{
	interactive = val;
}

bool System::isInteractive()
{
	return interactive;
}

///////////// Other stuff

bool System::isLittleEndian()
{
	short t = 1;
	return (((char*)(&t))[0] != 0);
}

int stdCompare(char elem1, char elem2)
{
	return int(elem1) - int(elem2);
}



} // namespace

///////////////// System specific stuff //
#ifdef __SYMBIAN32__
#include "rtsystem.epoc.cpp"
#else
  #ifdef __WIN32__
  #include "rtsystem.win32.cpp"
  #else
  #include "rtsystem.stdlib.cpp"
  #endif
#endif
