/** @file robconsole.h
  * All Console specific stuff for RoboTour.
  */

#ifndef __RT_ROBCONSOLE__
#define __RT_ROBCONSOLE__

#include "robfrontend.h"
#include "robmanage.h"

#include <rtcollect.h>
#include <rtstring.h>
#include <rtsystem.h>

namespace rt {

class ConsoleFrontend;
class ConsoleBotPresenter;
class FieldPrinter;
class DebugPrinter;


class ConsoleFrontend : public Frontend {

public:
	ConsoleFrontend();
	virtual ~ConsoleFrontend();

	// from ErrorHandler
	virtual void handleLoadError(const String& affectedFile, const String& message) const;
	virtual void handleBotError(const Bot* affectedBot, ExecReturnType type) const;
	virtual void handleSystemError(int num, const String& message) const;
	virtual void handleWarning(const String& message) const;

	virtual bool interpreteParamsImpl(const Array<String>& params, Array<bool>& used);
	virtual void fillOptions(SimOptions& options);

protected:
	class MyTourDisplayer : public TourDisplayer {
	public:
		MyTourDisplayer(ConsoleBotPresenter* cbp = 0);
		virtual void init(const TourInitInfo&);
		virtual TourStatusType update(const Array<TourResult>& status);
		virtual void exit(TourStatusType exitType, const Array<TourResult>& result);

	private:
		Time starttime;
		ConsoleBotPresenter* cbp;
	};
	int verbose;
	int printtime;
	int debugtime;
	String debugrange;

	void printHelp();
};

class ConsoleBotPresenter : public SimSupervisor {

public:
	ConsoleBotPresenter(bool verbose);
	virtual ~ConsoleBotPresenter();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);
	virtual void exitSim(Simulation* const sim, const GameState& simResult);
	void initTour(const TourInitInfo&);

private:
	int simNum, simCount;
	bool verbose;
	GameState retState;
};

class FieldPrinter : public SimSupervisor {

public:
	FieldPrinter(int printtime);
	virtual ~FieldPrinter();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	int printtime;
	GameState retState;
	String boundary;
};


class DebugPrinter : public SimSupervisor {

public:
	DebugPrinter(int debugtime, String debugrange);
	virtual ~DebugPrinter();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	int debugtime;
	int sx, sy, ex, ey;
	GameState retState;
};


} // namespace

#endif

