#ifndef __RT_SUPERVISORS__
#define __RT_SUPERVISORS__

#include "robbase.h"

#include <rtstring.h>

using namespace lrt;

namespace rt {

/** Creates a robot for each Program at the beginning of the Simulation. */
class StdBotCreator : public SimSupervisor {

public:
	StdBotCreator();
	virtual ~StdBotCreator();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	GameState retState;
};

/** Checks if the Simulation is finished using default rules. */
class StdVictorySupervisor : public SimSupervisor {

public:
	StdVictorySupervisor();
	virtual ~StdVictorySupervisor();

	virtual SimSuperPosition getPreferredPosition();
	virtual unsigned long getStepCycles();
	virtual void initSim(Simulation* const sim);
	virtual GameState exec(Simulation* const sim);

private:
	GameState retState;
};




} // namespace

#endif
