#ifndef __RT_WX_HISTORY__
#define __RT_WX_HISTORY__

#include <wx/wx.h>

class RoboTourEvent;

class HistoryCtrl : public wxControl 
{
public:
	HistoryCtrl(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size);
	~HistoryCtrl();

	void SetMaximum(int max);
	void ClearHistory();
	void UpdateFrom(RoboTourEvent&);

	DECLARE_EVENT_TABLE()
protected:
	wxSize DoGetBestSize();
private:
	void EnsureSize(const wxSize&);
	void Paint(wxDC& dc);

	void OnSize(wxSizeEvent&);
	void OnEraseBackground(wxEraseEvent&) { /* do nothing */ }
	void OnPaint(wxPaintEvent&);

	int max;
	int screenPos, bmpPos;
	wxBitmap* buf;
	int lastCycle, minInterval; 
};



#endif
