/*
 * rtstring.inline.cpp
 * 
 * Copyright (c) 2000-2004 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

/////////////// Inline member functions for class String.

#ifndef __LRT_STRING_INLINE__
#define __LRT_STRING_INLINE__

#include "rtmath.h"

namespace lrt {

inline bool String::operator == (const String& str) const
{
	if(len != str.len) return false;
	return (compare(0, str, 0, len) == 0);
}

inline bool String::operator != (const String& str) const
{
	if(len != str.len) return true;
	return (compare(0, str, 0, len) != 0);
}

inline bool String::operator < (const String& str) const
{
	return (compare(str) < 0);
}

//! Returns a negative, zero, or a positive number as this is less, equal, or greater than str.
inline int String::compare(const String& str) const
{
	int ret = compare(0, str, 0, Math::min(len, str.len));
	if((ret == 0) && (len != str.len))
		return len - str.len;
	return ret;
}

//! Returns a negative, zero, or a positive number as this is less, equal, or greater than str.
inline int String::compareIgnoreCase(const String& str) const
{
	int ret = compareIgnoreCase(0, str, 0, Math::min(len, str.len));
	if((ret == 0) && (len != str.len))
		return len - str.len;
	return ret;
}

inline int String::compare(const String& str1, const String& str2) 
{
	return str1.compare(str2);
}

inline int String::compareIgnoreCase(const String& str1, const String& str2) 
{
	return str1.compareIgnoreCase(str2);
}


inline bool String::startsWith(const String &str) const
{
	if(str.len > len) return false;
	return (compare(0, str, 0, str.len) == 0);
}

inline bool String::endsWith(const String &str) const
{
	if(str.len > len) return false;
	return (compare(len - str.len, str, 0, str.len) == 0);
}

} // namespace

#endif

