/*
 * rtsound.unix.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// This is a hack!
// This implementation uses the command 'play' to play sounds.
// It will probably only work under very few unixes.

#ifndef __LRT_SOUND_UNIX__
#define __LRT_SOUND_UNIX__

#include "rtsound.h"
#include "rtstring.h"
#include "rtfile.h"
#include <stdio.h>
#include <stdlib.h>

namespace lrt {

bool Sound::isSupported()
{
	// test if system function is available (system(0) should return true)
	if(!system(0)) return false;
	// test for play command
	if(system("play --version")) return false;

	return true;
}

String Sound::getExtension()
{
	return ".wav"; // and many others...
}

// stop is ignored
bool Sound::play(const String& logicalSoundName, bool sync, bool stop)
{
	String soundfile = resolve(logicalSoundName);
	if(soundfile == String()) return false;
	
	String cmd = "play ";
	cmd += soundfile;
	
	if(!sync)
	  cmd += " &";
	return (system(cmd.cStr()) == 0);
}



} // namespace

#endif

