/*
 * reportdata.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

#include <wx/wx.h>
#include "reportdata.h"

#include "reportctrl.h"

wxxReportData::wxxReportData() : ctrl(0), colCount(0), infos(0), 
	delInfos(wxREPORT_DELNOTHING), sortOrder(wxREPORT_ASCENDING), sortColumn(-1)
{
}

wxxReportData::wxxReportData(int colCount, const wxxReportColumnInfo** infos, wxxReportDeleteMode delInfos) :
	ctrl(0), colCount(colCount), infos(infos), delInfos(delInfos),
	sortOrder(wxREPORT_ASCENDING), sortColumn(-1)
{
}

wxxReportData::~wxxReportData()
{
	if(delInfos & wxREPORT_DELELEMENTS) {
		for(int i = 0; i < colCount; i++)
			delete infos[i];
	}
	if(delInfos & wxREPORT_DELARRAY) {
		delete[] infos;
	}
}

int wxxReportData::GetColumnCount()
{
	return colCount;
}

int wxxReportData::GetColumnWidth(int col)
{
	if(!infos || (col < 0) || (col > GetColumnCount()))
		return wxREPORT_AUTOSIZE;
	return infos[col]->width;
}

wxString wxxReportData::GetColumnTitle(int col)
{
	if(!infos || (col < 0) || (col > GetColumnCount()))
		return wxString();
	return infos[col]->title;
}

wxxReportTextAlign wxxReportData::GetColumnAlign(int col)
{
	if(!infos || (col < 0) || (col > GetColumnCount()))
		return wxREPORT_LEFT;
	return infos[col]->align;
}

int wxxReportData::GetImage(long row)
{
	return -1;
}

void wxxReportData::SortItems()
{
	if(!ctrl || (sortColumn < 0)) return; // nothing to sort
	ctrl->SortItems(wxReportCtrlCompareFunction, (long)ctrl);
}

int wxxReportData::CompareItems(long row1, long row2)
{
	wxString text1 = GetItemText(row1, GetSortColumn());
	wxString text2 = GetItemText(row2, GetSortColumn());
	int res = text1.CmpNoCase(text2.c_str());
	res *= GetSortOrder();

	return res;
}

bool wxxReportData::DoColumns()
{
	if(ctrl)
		return ctrl->DoColumns();
	return false;
}

bool wxxReportData::DoRows(int start, int end)
{
	if(ctrl)
		return ctrl->DoRows(start, end);
	return false;
}

