/*
 * robstrings.cpp
 * 
 * Copyright (c) 2000-2005 by Florian Fischer (florianfischer@gmx.de)
 * and Martin Trautmann (martintrautmann@gmx.de) 
 * 
 * This file may be distributed and/or modified under the terms of the 
 * GNU General Public License version 2 as published by the Free Software 
 * Foundation. 
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

// Contains lots of user-visible names and strings

#include <rtstring.h>

#include "robstrings.h"
#include "robtrans.h"

namespace rt {

const char* simVarNames[] = {
	"$Fields",
	"#Pub",
	"$Time",
	"$MaxGeneration",
	"$MaxVars",
	"$MaxTasks",
	"$MaxMybots",
	"$Timeout",
	"$ElimTrigger",
	"$MaxLifetime", // for child bots
	"$MaxLifetime"  // for mother bots
};

const char* progVarNames[] = {
	"$MyBots",
	"$OtherBots",
	"$ID"
};

const char* botVarNames[] = {
	"#Active",
	"$Banks",
	"$Generation",
	"!PosX",
	"!PosY",
	"$InstrSet",
	"$Mobile",
	"$Tasks"
};

const char* taskVarNames[] = {
	"!RunBank",
	"$InstrPos",
	"!Dir",
	"!NumCyclesReq",
	"!NumCyclesDone",
	"!TimingMode"
};
	
const char* failMsg[] = {
	_N("Instruction terminated successfully"),
	_N("Elimination Trigger released"),
	_N("Data Hunger"),
	_N("Division by zero"),
	_N("Invalid source or target bank"),
	_N("Higher instruction set required"),
	_N("Mobility required"),
	_N("DIE executed"),
	_N("Invalid parameter"),
	_N("Unemployment: no tasks left"),
	_N("Instruction duration too high"),
	_N("Maximum Lifetime exceeded"),
	_N("Quit executed")
};

const char* robLoadFailMsg[] = {
	_N("Robot loaded successfully"),
	_N("No banks defined in bot"),
	_N("Unknown command"),
	_N("Unknown parameter"),
	_N("Wrong number of parameters"),
	_N("Comma expected"),
	_N("Bank expected"),
	_N("Undefined label"),
	_N("Label declared twice"),
	_N("File not found"),
	_N("Not enough memory"),
	_N("RC3 instructions required"),
	_N("Multitasking required"),
	_N("Too many banks in bot"),
	_N("Too many instructions in bank"),
	_N("Generic Define Error"),
	_N("Undeclared Define parameter"),
	_N("Too many Define parameters"),
	_N("Ampersand '&' expected"),
	_N("Opening brace '{' expected"),
	_N("Closing brace '}' expected"),
	_N("Opening bracket '(' expected"),
	_N("Closing bracket ')' expected"), 
	_N("Question mark '?' expected"),
	_N("Too many recursion levels"),
	_N("Undeclared define"),
	_N("Define declared twice"),
	_N("Invalid character in identifier"),
	_N("End of line expected")
};

const char* rbiLoadFailMsg[] = {
	_N("RBI loaded successfully"),
	_N("No banks defined in bot"),
	_N("Unknown command"),
	_N("Unknown parameter"),
	_N("Wrong number of parameters"),
	_N("File not found"),
	_N("Not enough memory"),
	_N("RC3 instructions required"),
	_N("Multitasking required"),
	_N("Too many banks in bot"),
	_N("Too many instructions in bank"),
	_N("Unexpected end of file"),
	_N("Unknown error")
};

const char* genLoadFailMsg[] = {
	_N("Unsupported RoboCom Language version")
};


/* Translate them all. */


lrt::String getFailMsg(ExecReturnType rt)
{
	// error return types are all negative
	if(rt <= 0) {
		return _(failMsg[-rt]);
	}
	return ""; 
}

lrt::String getRobLoadFailMsg(RobLoadReturnType rt)
{
	return _(robLoadFailMsg[rt]);
}

lrt::String getRbiLoadFailMsg(RbiLoadReturnType rt)
{
	return _(rbiLoadFailMsg[rt]);
}

lrt::String getGenLoadFailMsg(GenLoadFailType rt)
{
	return _(genLoadFailMsg[rt]);
}






} // namespace
