function M=%ce_i_ce(varargin)
// Authors: F. Delebecque, S. Steer, V. Couvert, Copyright INRIA 
//insert the cell varargin($-1) into the cell varargin($)
//at position varargin(1), varargin(2),varargin(3),...
//insert the cell varargin($-1) as the field varargin(1)
//of the cell varargin($)
  [lhs,rhs]=argn(0)
  M=varargin($)
  N=varargin($-1)//inserted matrix
  dims=double(matrix(M.dims,1,-1));
  
  if type(varargin(1))==10 //addind a new field
    flds=getfield(1,M);flds=[flds,varargin(1)];
    setfield(1,flds,M);setfield($+1,N,M);
    if and(dims==[0 0]) then M.dims=int32([1 1]),end
  else   //Subscripted assignment between structures
    
    //build resulting struct fields
    FM=getfield(1,M);FM=FM(3:$);nFM=size(FM,'*')
    FN=getfield(1,N);FN=FN(3:$);nFN=size(FN,'*')
    FR=FM;for f=FN, if and(f<>FM) then FR=[FR,f],end,end

    Nfields=size(FR,'*')
    //computing the dimension of the result
    nd=size(dims,'*')
    if rhs-2>nd then dims(nd+1:rhs-2)=1;end  

    //convert N-dimensionnal indexes to 1-D and extend dims if necessary
    [Ndims,I]=convertindex(list(dims,double(matrix(N.dims,1,-1))),varargin(1:$-2));Ndims=matrix(Ndims,1,-1)

    if or(Ndims>dims) then
      //extend the destination matrix
      I1=0
      for k=size(Ndims,'*'):-1:1
	ik1=(1:dims(k))'
	if ik1<>[] then
	  if Ndims(k)>1 then
	    if size(I1,'*')>1 then
	      I1=(Ndims(k)*I1).*.ones(ik1)+ones(I1).*.(ik1-1)
	    else
	      I1=Ndims(k)*I1+ik1-1
	    end
	  else
	    I1=Ndims(k)*I1+ik1-1
	  end
	end
      end
      v1=list();for k=1:prod(Ndims),v1(k)=[];end
      // create the resulting matrix
      R=mlist(["ce",'dims',matrix(FR,1,-1)],int32(Ndims));
      for k=1:size(FR,'*'),setfield(2+k,v1,R),end
      // populate it with M entries
      for k=1:nFM
	v2=v1;
	kf=find(FR==FM(k));
	w=getfield(k+2,M);if type(w)<>15 then w=list(w),end
	for i=1:size(I1,'*'), 
	  if w<>list() then
	    v2(I1(i)+1)=w(i)
	  else
	    v2(I1(i)+1)=[]
	  end
	end
	setfield(kf+2,v2,R);
      end
    else //the dimension agree
      R=M
      //does the fields agree?
      if or(FR<>FM) then //no
	//add new fields
	setfield(1,["ce",'dims',FR],R)
	v1=list();for k=1:prod(Ndims),v1(k)=[];end
	for k=nFM+1:size(FR,'*')
	  setfield($+1,v1,R)
	end
      end
    end
	  
    //insert N entries into result  
    for k=1:nFN
      kf=find(FR==FN(k))
      v2=getfield(kf+2,R)
      w=getfield(k+2,N);
      if type(w)<>15 then w=list(w),end
      for i=1:size(I,'*'), 
	if w<>list() then
	  v2(I(i))=w(i)
	else
	  v2(I(i))=[]
	end
       end 
      if length(v2)==1 then v2=v2(1);end
      setfield(kf+2,v2,R);
    end
    
    //remove trailing unitary dimensions
    while  Ndims($)==1 then Ndims($)=[],end
    select size(Ndims,'*')
      case 0 then
      Ndims=[1,1]
      case 1 then
      Ndims=[Ndims,1]
    else 
      Ndims=matrix(Ndims,1,-1)
    end
    
    R.dims=int32(Ndims)
    M=R
  end
endfunction


