#include "treedraw.h"
#include <time.h>
#include <ctype.h>
#include "FL/Fl_Native_File_Chooser.H"

extern int printout_block, printout_fontsize, printout_black, printout_vary;
extern paperformat printout_pageformat;
extern char *prepare_ps_or_pdf_font(int font_num);
extern paperformat printout_pageformat;
extern int pdf_or_ps_plot, page_count, ps_width; 
extern double physx, physy, maxx, nexty;
extern char *end_br_length;
extern float postscript_ratio;
extern FILE *plotfile;
extern void mem_plot(FD_nj_plot *fd_nj_plot, struct noeud *pere, struct noeud *centre, double currx,
					 double *curry);
extern void do_plot(FD_nj_plot *fd_nj_plot, int doing_print);


int postscript_printout(SEA_VIEW *view, const char *filename, 
	int fontsize, int block_size, paperformat pageformat, int vary_only, int ref0, int blackonly);
static void color_ps_display(FILE *psout, SEA_VIEW *view, int (*calc_color_function)( int ), char *oneline, 
	int widnames, int x, int y, int fontsize, int char_width, int descender);
static int calc_vary_lines(int *vary_pos, int widpos);
static void out_vary_pos(int *vary_pos, int widnames, int widpos, int nl, FILE *psout, 
	int x, int y, int yoffset);
void postscript_tree_plot(FD_nj_plot *fd_nj_plot);


int postscript_printout(SEA_VIEW *view, const char *filename, 
	int fontsize, int block_size, paperformat pageformat, int vary_only, int ref0, int blackonly)
{
int num, i, j, k, current, max_seq_length, fin, curr_lines, widnames, 
	res_per_line, nl, firstpage, lines_per_page;
time_t heure;
static char unnamed[] = "<unnamed>";
static char num_line[200];
int lettre, char_per_line;
short *vary_need = NULL;
int *vary_pos; /* rang ds alignement de la colonne imprimee */
char oneline[500];
int (*calc_color_function)(int);
FILE *psout;
int	char_width, width, height, descender, margin = 25;
float postscript_ratio;
char	*fontname;
int curpage, erreur = FALSE;
const int a4_width = 595;
const int a4_height = 842;
const int letter_width = 612;
const int letter_height = 792;

    fontname	= (char *)"Courier-Bold";
if(view->tot_seqs == 0) return 0;
if(view->protein) calc_color_function = get_color_for_aa;
else  calc_color_function = get_color_for_base;
if(pageformat == A4) { width = a4_width; height = a4_height; }
else /* LETTER */ { width = letter_width; height = letter_height; }
lines_per_page = (height - 2*margin) / fontsize ;

psout = fopen(filename, "w");
if(psout == NULL) return TRUE;

fprintf(psout,"%%!PS-Adobe-3.0\n"
	"%%%%DocumentFonts: %s \n"
	"%%%%Creator: seaview\n"
	"%%%%Pages: (atend)\n"
	"%%%%Title: %s\n"
	"%%%%BeginFeature: *PageSize \n"
 	"%s\n"
	"%%%%EndFeature\n"
	"%%%%EndComments\n", fontname,
	 PREPARE_LABEL(view->masename), pageformat == A4 ? "a4" : "letter" );


postscript_ratio = 0.60;
char_width = (int)(fontsize * postscript_ratio + 0.5);
char_per_line = (width - 2*margin) / char_width ;
descender = - (int)(fontsize * 0.20 + 0.5); 

fprintf(psout,"%%%%BeginProlog\n/uniqfont /%s findfont %d scalefont def\n%%%%EndProlog\n", 
	fontname, fontsize);

curpage = 1;
fprintf(psout,"%%%%Page: ? 1\n");

fprintf(psout,"uniqfont setfont\n");
fprintf(psout,"%d %d moveto\n", margin, height - margin - fontsize);
firstpage = TRUE;

if(ref0 < 0) vary_only = FALSE;
time(&heure);
sprintf(oneline,"Alignment: %s", view->masename == NULL ? unnamed : PREPARE_LABEL(view->masename) );
fprintf(psout,"(%s) show\n", oneline);
curr_lines = 1;
if(vary_only) {
	fprintf(psout,"%d %d moveto\n", margin, height - margin - (++curr_lines) * fontsize);
	fprintf(psout,"(Displaying variable sites only.) show\n");
	}
sprintf(oneline,"Seaview [blocks=%d fontsize=%d %s] on %s",
		block_size, fontsize, pageformat == A4 ? "A4" : "LETTER", ctime(&heure));
fprintf(psout,"%d %d moveto\n", margin, height - margin - (++curr_lines) * fontsize);
fprintf(psout,"(%s) show\n", oneline);
++curr_lines;
max_seq_length = 0; widnames = 0;
for(i=0; i < view->tot_seqs; i++) {
	if(view->each_length[i] > max_seq_length) max_seq_length = view->each_length[i];
	if( ( fin=strlen(view->seqname[i]) ) > widnames) widnames = fin;
	}
widnames += 2;
if(vary_only) {
	vary_need = (short *)calloc(max_seq_length, sizeof(short));
	if(vary_need == NULL) return TRUE;
	vary_pos = (int *)calloc(char_per_line, sizeof(int));
	if(vary_pos == NULL) return TRUE;
	for(i = 0; i < max_seq_length; i++) {
		for(num = 0; num < view->tot_seqs; num++) {
			if( toupper(view->sequence[num][i]) != toupper(view->sequence[ref0][i]) ) { 
				vary_need[i] = TRUE;
				break;
				}
			}
		}
	}
/* nombre max de blocks qui tiennent sur une ligne de cpl chars */
fin = (char_per_line - widnames + 1) / (block_size + 1);
if(fin < 1) { /* garde fou */
	fin = 1; block_size = char_per_line - widnames;
	}
res_per_line = fin * block_size;
current = 0; 
while( current < max_seq_length ) {
	nl = 1;
	if(vary_only) { 
		memset(vary_pos, 0, res_per_line * sizeof(int) );
		i = -1; j = 0; k = 0;
		while( j < res_per_line) {
			if(current + i >= max_seq_length) break;
			if( !vary_need[current + ++i] ) continue;
			j++;
			vary_pos[k++] = current + i + 1;
			if( j % block_size == 0) k++;
			}
		nl = calc_vary_lines(vary_pos,  k);
		}
	if( (!firstpage) && curr_lines + view->tot_seqs + nl > lines_per_page) {
		fprintf(psout,"showpage\n");
		fprintf(psout,"%%%%Page: ? %d\n", ++curpage);
		fprintf(psout,"uniqfont setfont\n");
		curr_lines = 0;
		}
	if(vary_only) {
		out_vary_pos(vary_pos, widnames, k, nl, psout, margin, height - margin - (curr_lines+1) * fontsize, fontsize);
		curr_lines += nl;
		}
	else	{
		sprintf(num_line, "%d", current + 1);
		fin = strlen(num_line);
		memmove(num_line + widnames - fin + 1, num_line, fin+1);
		if(fin <= widnames) memset(num_line, ' ', widnames - fin + 1);
		fprintf(psout,"%d %d moveto\n", margin, height - margin - (curr_lines+1) * fontsize);
		fprintf(psout,"(%s) show\n", num_line);
		++curr_lines;
		}
	for(num=0; num < view->tot_seqs; num++) {
		k = 0;
		for(j = 0; j < widnames; j++) {
			if(view->seqname[num][j] == 0) break;
			oneline[k++] = view->seqname[num][j];
			}
		while( j < widnames) {
			j++;
			oneline[k++] = ' ';
			}
		if(vary_only) {
			i = -1; j = 0;
			while( j < res_per_line) {
				if(current + i >= max_seq_length) break;
				if( !vary_need[current + ++i] ) continue;
				j++;
				if(current + i < view->each_length[num]) {
					if(num != ref0) lettre = ( toupper(view->sequence[num][current+i]) == 
						toupper(view->sequence[ref0][current+i]) ? '.' : view->sequence[num][current+i] );
					else lettre = view->sequence[ref0][current+i];
					oneline[k++] = lettre;
					}
				if( j % block_size == 0) oneline[k++] = ' ';
				}
			if(num == view->tot_seqs - 1) current = current + i + 1;
			}

		else	{
			fin = res_per_line;
			if(current+fin > view->each_length[num]) 
				fin = view->each_length[num] - current;
			if(ref0 != -1 && num != ref0) {
				/* ecriture par reference a seq ref0 */
				for(i=0; i<fin; i++) {
					lettre = ( toupper(view->sequence[num][current+i]) == 
						toupper(view->sequence[ref0][current+i]) ? '.' : view->sequence[num][current+i] );
					oneline[k++] = lettre;
					if( i < fin-1 && (i+1)%block_size == 0) 
						oneline[k++] = ' ';
					}
				}
			else	{ /* ecriture normale de seq */
				for(i=0; i<fin; i++) {
					oneline[k++] = view->sequence[num][current+i];
					if( i < fin-1 && (i+1)%block_size == 0) 
						oneline[k++] = ' ';
					}
				}
			}
		oneline[k] = 0;
		if(curr_lines >= lines_per_page) {
			fprintf(psout,"showpage\n");
			fprintf(psout,"%%%%Page: ? %d\n", ++curpage);
			fprintf(psout,"uniqfont setfont\n");
			curr_lines = 0;
			}
		if(blackonly) {
			fprintf(psout,"%d %d moveto\n", margin, height - margin - (curr_lines+1) * fontsize);
			fprintf(psout,"(%s) show\n", oneline);
			}
		else 
			color_ps_display(psout, view, calc_color_function, oneline, widnames, margin, 
				height - margin - (curr_lines+1) * fontsize, fontsize, char_width, descender);
		++curr_lines;
		firstpage = FALSE;
		}
	if(curr_lines + 1 <= lines_per_page) {
		++curr_lines;
		}
	if( ! vary_only ) current += res_per_line;
	}
fprintf(psout,"showpage\n");
fprintf(psout, "%%%%Trailer\n%%%%Pages: %d\n%%%%EOF\n", curpage);
if(ferror(psout)) erreur = TRUE;
if(fclose(psout) != 0) erreur = TRUE;
return erreur;
}


static void color_ps_display(FILE *psout, SEA_VIEW *view, int (*calc_color_function)( int ), char *oneline, 
	int widnames, int x, int y, int fontsize, int char_width, int descender)
{
uchar red, green, blue;
double r, g, b;
int xx;
int c, l;
char *p, **clines;

clines = (char **)malloc(sizeof(char *) * view->numb_gc); if(clines==NULL) return;
l = strlen(oneline);
for(c = 1; c < view->numb_gc; c++) {
	clines[c] = (char *)malloc(l + 1); if(clines[c] == NULL) return;
	memset(clines[c], ' ', l); clines[c][l] = 0;
	}
for(p = oneline + widnames; *p != 0; p++) {
	c = calc_color_function(*p);
	if(c > 0) clines[c][p - oneline] = 'X';
	}
for(c = 1; c < view->numb_gc; c++) {
	if(strchr(clines[c], 'X') == NULL) continue;
	Fl::get_color((Fl_Color)view->curr_colors[c], red, green, blue);
	r = red/255.; g = green/255.; b = blue/255.;
	fprintf(psout,"%f %f %f setrgbcolor\n", r, g, b);
	for(xx = x + widnames*char_width, p = clines[c] + widnames; *p != 0; p++, xx += char_width) {
		if(*p == ' ') continue;
		fprintf(psout, "%d %d %d %d rectfill\n", 
			xx, y+descender, char_width, fontsize);	
		}
	}
fprintf(psout,"0 setgray\n");
fprintf(psout,"%d %d moveto\n", x, y);
fprintf(psout,"(%s) show\n", oneline);
for(c = 1; c < view->numb_gc; c++) free(clines[c]);
free(clines);
}


static int calc_vary_lines(int *vary_pos, int widpos)
{
int maxi = 0, num, nl;

for(num = 0; num < widpos; num++) 
	if(vary_pos[num] > maxi) maxi = vary_pos[num];
if(maxi >= 100000)
	 nl = 6;
else if(maxi >= 10000)
	 nl = 5;
else if(maxi >= 1000)
	 nl = 4;
else if(maxi >= 100)
	 nl = 3;
else if(maxi >= 10)
	 nl = 2;
else 	
	 nl = 1;
return nl;
}


static void out_vary_pos(int *vary_pos, int widnames, int widpos, int nl, FILE *psout, 
	int x, int y, int yoffset)
{
int num, l, k, echelle, digit, val;
static char chiffre[] = "0123456789";
char oneline[300];

echelle = 1; k = 0;
for(l = 2; l <= nl; l++) echelle *= 10;
for(l = nl; l > 0; l--) {
	for(num = 0; num < widnames; num++) oneline[k++] = ' ';
	for(num = 0; num < widpos; num++) {
		val = vary_pos[num];
		if(val < echelle)
			oneline[k++] = ' ';
		else	{
			digit = (val / echelle) % 10 ;
			oneline[k++] = *(chiffre + digit);
			}
		}
	oneline[k] = 0;
	fprintf(psout,"%d %d moveto\n", x, y); y -= yoffset;
	fprintf(psout,"(%s) show\n", oneline);
	k = 0;
	echelle /= 10;
	}
}

void postscript_tree_plot(FD_nj_plot *fd_nj_plot)
{
	double currx, curry;
	int page, erreur = FALSE, offset;
	int paper_h, sheets_h, recouvre;
	const int a4_h = 750, letter_h = 700;
	time_t heure;
	float screen_w, ps_w;
	static int first = TRUE;
	const char alphabet[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	FILE *f;
	/* partie dessinable 500(ps_width) x a4_h decalee de 50 x 50 par rapport a coin inferieur gauche du papier
	 cadre exterieur de 10 sur les 4 cotes, correspond aussi a zone de clip
	 */
	
	if(fd_nj_plot->notu == 0) return;
	if(printout_pageformat == A4) {
		paper_h = a4_h;
	}
	else {
		paper_h = letter_h;
	}
	
	Fl_Native_File_Chooser *chooser = new Fl_Native_File_Chooser();
	chooser->type(Fl_Native_File_Chooser::BROWSE_SAVE_FILE);
	chooser->title("Set PostScript filename");       
	char tmp[100];
	strcpy(tmp, extract_filename(fd_nj_plot->tree_name));
	char *p = strrchr(tmp, '.'); if(p != NULL) *p = 0;
	strcat(tmp, ".ps");
	chooser->preset_file(tmp);
	char *plotfilename = run_and_close_native_file_chooser(chooser);
	if(plotfilename == NULL) return;
	if( (f = fopen(plotfilename, "r")) != NULL) {
		fclose(f);
		if(fl_choice("File %s already exists.", "Cancel", "Overwrite", NULL, plotfilename) == 0) return;
	}
	
	if(first) {
		first = FALSE;
		fl_font(FL_COURIER, 12);
		screen_w = fl_width(alphabet);/*taille sur ecran*/
		ps_w = 12 * 0.60 * 26; /*taille en postscript pour courier,12*/
		postscript_ratio = ps_w / screen_w ;
	}
	/* recouvre = paper_h / 30; */
	recouvre = 0;
	sheets_h = (paper_h - recouvre) * page_count + recouvre;
	offset = paper_h - recouvre;
	physx = ps_width;
	physy = sheets_h;
	
	
	plotfile=fopen(plotfilename,"w");
	if(plotfile == NULL) {
		fl_alert("Error opening %s for writing\n", plotfilename);
		return;
	}
	pdf_or_ps_plot = TRUE;
	my_watch_cursor(fd_nj_plot->full->window());
	char *current_ps_font = prepare_ps_or_pdf_font(fd_nj_plot->font_family);
	fprintf(plotfile,"%%!PS-Adobe-1.0\n"
			"%%%%DocumentFonts: Times-Roman %s\n"
			"%%%%Creator: seaview\n"
			"%%%%Pages: %d\n"
			"%%%%Title: %s\n"
			"%%%%BeginFeature: *PageSize \n"
			"%s\n"
			"%%%%EndFeature\n"
			"%%%%EndComments\n",
			current_ps_font, page_count, fd_nj_plot->tree_name, printout_pageformat == A4 ? "a4" : "letter" );
	fprintf(plotfile,
			"/setpacking where {true setpacking} if\n"
			"1 setlinecap 1 setlinejoin 1 setlinewidth 0 setgray\n"
			"/basefont /%s findfont %d scalefont def\n",
			current_ps_font, fd_nj_plot->font_size);
	fprintf(plotfile,"/titlefont /Times-Roman findfont 12 scalefont def\n");
	fprintf(plotfile, "/setclip {40 40 moveto %d 40 lineto %d %d lineto 40 %d "
			"lineto closepath clip newpath} def\n", 
			ps_width + 60, ps_width + 60, paper_h+60, paper_h+60);
	time(&heure);
	fprintf(plotfile, "/title {titlefont setfont\n"
			"40 %d moveto (%s   %s) show (  Page ) show show ( of %d) show\n"
			"} def\n", 
			paper_h+65, extract_filename(fd_nj_plot->tree_name), ctime(&heure), page_count);
	fprintf(plotfile,"%%%%EndProlog\n");
	
	fd_nj_plot->totnoms = fd_nj_plot->tottraits = fd_nj_plot->totpoints = -1;
	end_br_length = fd_nj_plot->br_length_txt;
	currx = 0.;
	maxx = 0.;
	nexty = -fd_nj_plot->deltay;
	fl_font(fd_nj_plot->font_family, fd_nj_plot->font_size);/*retour a police courante pour ecran */
	if(fd_nj_plot->subtree_center == NULL)
		mem_plot(fd_nj_plot, NULL, fd_nj_plot->racine, currx, &curry);
	else
		mem_plot(fd_nj_plot, fd_nj_plot->subtree_ascend, fd_nj_plot->subtree_center, currx, &curry);
	for(page = 0; page < page_count ; page++) {
		fprintf(plotfile,"%%%%Page: ? %d\n", page+1);
		fprintf(plotfile,"(%d) title ", page+1);
		fprintf(plotfile,"setclip\n");
		fprintf(plotfile,"0 %d translate\n", - (page_count - page - 1) * offset);
		fprintf(plotfile,"basefont setfont\n");
		fprintf(plotfile,"50 50 translate\n");
		fprintf(plotfile,"0.7 setgray -10 -10 moveto %d -10 lineto %d %d lineto "
				"-10 %d lineto closepath stroke 0 setgray \n", 
				ps_width + 10, ps_width + 10, sheets_h+10, sheets_h+10);
		do_plot(fd_nj_plot, TRUE);
		fprintf(plotfile,"showpage\n");
	}
	fprintf(plotfile, "%%%%Trailer\n");
	if(ferror(plotfile)) erreur = TRUE;
	if(fclose(plotfile) != 0) erreur = TRUE;
	
	fd_nj_plot->need_runtree = TRUE;
	pdf_or_ps_plot = FALSE;
	fl_reset_cursor(fd_nj_plot->full->window());
	if(erreur  ) fl_alert("Error while writing to file %s", extract_filename(plotfilename) );
}


