#ifndef FL_SVG_GRAPHICS_DRIVER_H
#define FL_SVG_GRAPHICS_DRIVER_H

#include <stdio.h>
#include <FL/Fl_Device.H>

class Fl_SVG_Graphics_Driver : public Fl_Graphics_Driver {
  FILE *out_;
  int width_;
  const char *linecap_;
  uchar red_, green_, blue_;
public:
  Fl_SVG_Graphics_Driver(FILE*);
  ~Fl_SVG_Graphics_Driver();
  FILE* file() {return out_;}
protected:
  char *family_;
  const char *bold_;
  const char *style_;
  void rect(int x, int y, int w, int h);
  void rectf(int x, int y, int w, int h);
  void line_style(int style, int width, char *dashes=0);
  void line(int x1, int y1, int x2, int y2);
  void font_(int f, int s);
  void font(int f, int s);
  void draw(const char *str, int n, int x, int y);
  void draw(const char*, int, float, float) ;
  void draw(int, const char*, int, int, int) ;
  void rtl_draw(const char*, int, int, int) ;
  void color(uchar r, uchar g, uchar b);
  void color(Fl_Color c);
  void draw_image(const uchar*, int, int, int, int, int, int) ;
  void draw_image_mono(const uchar*, int, int, int, int, int, int) ;
  void draw_image(void (*)(void*, int, int, int, uchar*), void*, int, int, int, int, int) ;
  void draw_image_mono(void (*)(void*, int, int, int, uchar*), void*, int, int, int, int, int) ;
  void draw(Fl_RGB_Image*, int, int, int, int, int, int) ;
  void draw(Fl_Pixmap*, int, int, int, int, int, int) ;
  void draw(Fl_Bitmap*, int, int, int, int, int, int) ;
  double width(const char*, int) ;
  int height() ;
  int descent() ;
};

class Fl_SVG_File_Surface : public Fl_Surface_Device {
  int width_, height_;
public:
  static const char *class_id;
  const char *class_name() {return class_id;};
  Fl_SVG_File_Surface(int, int, FILE*, bool use_pdf_width = false);
  void end();
  int width() { return width_; }
  int height() { return height_; }
  ~Fl_SVG_File_Surface();
};

#endif // FL_SVG_GRAPHICS_DRIVER_H

