/*
 * Seti@Home firstime druid
 * (C) 2002 Jean-Michel Ardantz
 *
 * Author: Jean-Michel Ardantz <jmardantz@ifrance.com>
 *
 * Changelog:
 * $Log: seti_druid.c,v $
 * Revision 1.1.2.2  2003/01/23 23:37:28  r_kinder
 * Do a 'make indent' on the files. Remove legacy code that is no longer
 * pertinant.
 *
 * Revision 1.1.2.1  2002/11/05 21:31:30  jmardantz
 * Gnome 2 port
 *
 *
 */

#include "config.h"
#include "seti_applet.h"
#include "seti_control.h"
#include "seti_druid.h"

#include <gtk/gtk.h>
#include <libgnomeui/libgnomeui.h>
#include <glade/glade.h>

// Defines
#define GLADE_FILE   GLADEDIR "/seti-applet.glade.glade"

// Prototypes of statics
static gboolean is_valid_mail(gchar * email);
static void new_user_druid_cancel(GnomeDruid * druid,
                                  gpointer user_data);
static void new_user_druid_finish(GnomeDruidPage * page,
                                  GnomeDruid * druid,
                                  gpointer user_data);
static gboolean new_user_druid_page_back(GnomeDruidPage * page,
                                         GnomeDruid * druid,
                                         gpointer user_data);
static gboolean new_user_druid_page_next(GnomeDruidPage * page,
                                         GnomeDruid * druid,
                                         gpointer user_data);
static void new_user_druid_standard_prepare(GnomeDruidPage * page,
                                            GnomeDruid * druid,
                                            gpointer user_data);
static void new_user_druid_lastpage_prepare(GnomeDruidPage * page,
                                            GnomeDruid * druid,
                                            gpointer user_data);
static void new_user_druid_entry_changed(GtkWidget * entry,
                                         gpointer user_data);


/*
 * is_valid_mail
 * This function check if the mail address
 * is like 'something@something.something'
 *
 * Param: the mail address
 */
static      gboolean
is_valid_mail(gchar * email)
{
    gchar      *str1_email = NULL;
    gchar      *str2_email = NULL;
    gboolean    valid = FALSE;

    // To check if the email is valid we are searching
    // for a character, followed by an '@' symbol,
    // followed by a '.' symbol, followed by a character
    str1_email = strstr(email, "@");

    // Check if there is a '@'
    if(str1_email == NULL)
        valid = FALSE;
    else
    {
        // Check if the '@' is in first position
        if(email == str1_email)
            valid = FALSE;
        else
        {
            str2_email = strstr(str1_email, ".");
            // Check if there is a '.' after the '@'
            if(str2_email == NULL)
                valid = FALSE;
            else
            {
                // Check if there is a '.' somewhere after the '@'
                if(strlen(str2_email) == 1)
                    valid = FALSE;
                else
                    valid = TRUE;
            }
        }
    }
    return valid;
}


/*
 * new_user_druid_cancel
 * This function is called when the Cancel
 * button is clicked in Druid
 *
 * Param: the Druid
 * Param: sa the setiapplet structure for the applet in use
 */
static void
new_user_druid_cancel(GnomeDruid * druid,
                      gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;

    start_stop_seti_cb(PANEL_APPLET(sa->applet_gui->applet), sa);

    gtk_widget_destroy(GTK_WIDGET(sa->druid_gui->window));
}


/*
 * new_user_druid_finish
 * This function is called when the finish
 * button is clicked in Druid
 *
 * Param: the Druid lastpage
 * Param: the Druid
 * Param: sa the setiapplet structure for the applet in use
 */
static void
new_user_druid_finish(GnomeDruidPage * page,
                      GnomeDruid * druid,
                      gpointer user_data)
{
    gchar      *emailAddress = NULL;
    gboolean    okemail = FALSE;
    gboolean    newaccount = FALSE;
    gchar      *name = NULL;
    gboolean    okname = FALSE;
    gchar      *postcode = NULL;
    gchar      *country = NULL;
    gchar      *location = NULL;
    gchar      *choice = NULL;
    setiapplet *sa = (setiapplet *) user_data;

    newaccount =
        gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                     (sa->druid_gui->radio_new_account));
    if(newaccount == TRUE)
    {
        // Setting up a new account
        choice = "1";
        emailAddress =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_new_email));
        okemail =
            (gboolean)
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->druid_gui->
                                          check_display_new_email));
        name =
            (gchar *) gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_name));
        okname =
            (gboolean)
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                         (sa->druid_gui->check_display_name));
        postcode =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_postal_code));
        country =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->combo_entry_country));
        location =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->combo_entry_location));
    }
    else
    {
        // Returning user
        choice = "2";
        emailAddress =
            (gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_existing_email));
    }

    // The two first input are necessary
    console_log_message(sa, choice);
    write(sa->seti_input, choice, strlen(choice));
    write(sa->seti_input, "\n", 1);
    console_log_message(sa, emailAddress);
    write(sa->seti_input, emailAddress, strlen(emailAddress));
    write(sa->seti_input, "\n", 1);

    // Others only for a new user account
    if(newaccount == TRUE)
    {
        if(okemail)
        {
            console_log_message(sa, "y");
            write(sa->seti_input, "y\n", 2);
        }
        else
        {
            console_log_message(sa, "n");
            write(sa->seti_input, "n\n", 2);
        }
        console_log_message(sa, name);
        write(sa->seti_input, name, strlen(name));
        write(sa->seti_input, "\n", 1);
        if(okname)
        {
            console_log_message(sa, "y");
            write(sa->seti_input, "y\n", 2);
        }
        else
        {
            console_log_message(sa, "n");
            write(sa->seti_input, "n\n", 2);
        }
        console_log_message(sa, country);
        write(sa->seti_input, country, strlen(country));
        write(sa->seti_input, "\n", 1);
        console_log_message(sa, postcode);
        write(sa->seti_input, postcode, strlen(postcode));
        write(sa->seti_input, "\n", 1);
        console_log_message(sa, location);
        write(sa->seti_input, location, strlen(location));
        write(sa->seti_input, "\n", 1);
        console_log_message(sa, "y");
        write(sa->seti_input, "y\n", 2);
    }

    gtk_widget_destroy(GTK_WIDGET(sa->druid_gui->window));
}


/*
 * new_user_druid_page_back
 * This function is use to go to the appropriate
 * page when the back button is pressed
 *
 * Param: the Druid page
 * Param: the Druid
 * Param: sa the setiapplet structure for the applet in use
 */
static      gboolean
new_user_druid_page_back(GnomeDruidPage * page,
                         GnomeDruid * druid,
                         gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;

    // Check if we are on page3
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->page3))
        gnome_druid_set_page(GNOME_DRUID(sa->druid_gui->druid),
                             GNOME_DRUID_PAGE(sa->druid_gui->page1));

    // Check if we are on lastpage
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->lastpage))
    {
        // Check if we are on New Account Setup
        if(gtk_toggle_button_get_active
           (GTK_TOGGLE_BUTTON(sa->druid_gui->radio_new_account)) == TRUE)
            gnome_druid_set_page(GNOME_DRUID(sa->druid_gui->druid),
                                 GNOME_DRUID_PAGE(sa->druid_gui->page4));
        else
            gnome_druid_set_page(GNOME_DRUID(sa->druid_gui->druid),
                                 GNOME_DRUID_PAGE(sa->druid_gui->page2));
    }

    // We don't want to continue the standard druid routine
    return TRUE;
}


/*
 * new_user_druid_page_next
 * This function is use to go to the appropriate
 * page when the next button is pressed
 *
 * Param: the Druid page
 * Param: the Druid
 * Param: sa the setiapplet structure for the applet in use
 */
static      gboolean
new_user_druid_page_next(GnomeDruidPage * page,
                         GnomeDruid * druid,
                         gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;

    // Check if we are on page1
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->page1))
    {
        // Check if we are on New Account Setup
        if(gtk_toggle_button_get_active
           (GTK_TOGGLE_BUTTON(sa->druid_gui->radio_new_account)) == TRUE)
            gnome_druid_set_page(GNOME_DRUID(sa->druid_gui->druid),
                                 GNOME_DRUID_PAGE(sa->druid_gui->page3));
        else
            gnome_druid_set_page(GNOME_DRUID(sa->druid_gui->druid),
                                 GNOME_DRUID_PAGE(sa->druid_gui->page2));
    }

    // Check if we are on page2
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->page2))
        gnome_druid_set_page(GNOME_DRUID(sa->druid_gui->druid),
                             GNOME_DRUID_PAGE(sa->druid_gui->lastpage));

    // We don't want to continue the standard druid routine
    return TRUE;
}


/*
 * new_user_druid_standard_prepare
 * This function is use to activate/desactivate
 * the next button if the entry is incomplete
 *
 * Param: the Druid page
 * Param: the Druid
 * Param: sa the setiapplet structure for the applet in use
 */
static void
new_user_druid_standard_prepare(GnomeDruidPage * page,
                                GnomeDruid * druid,
                                gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;

    // Check if we are on page2
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->page2))
        new_user_druid_entry_changed(sa->druid_gui->entry_existing_email, sa);

    // Check if we are on page3
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->page3))
    {
        new_user_druid_entry_changed(sa->druid_gui->entry_new_email, sa);
        new_user_druid_entry_changed(sa->druid_gui->entry_name, sa);
    }

    // Check if we are on page4
    if(page == GNOME_DRUID_PAGE(sa->druid_gui->page4))
        new_user_druid_entry_changed(sa->druid_gui->entry_postal_code, sa);
}


/*
 * new_user_druid_lastpage_prepare
 * This function is called before the 
 * lastpage of Druid if shown
 *
 * Param: the Druid lastpage
 * Param: the Druid
 * Param: sa the setiapplet structure for the applet in use
 */
static void
new_user_druid_lastpage_prepare(GnomeDruidPage * page,
                                GnomeDruid * druid,
                                gpointer user_data)
{
    setiapplet *sa = (setiapplet *) user_data;
    gchar      *summary;

    // Prepare the summary
    if(gtk_toggle_button_get_active
       (GTK_TOGGLE_BUTTON(sa->druid_gui->radio_new_account)) == TRUE)
    {
        summary =
            g_strdup_printf("%s\n\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s\n%s%s",
                            _
                            ("Here's your new account information. Click on terminate if everything is correct."),
                            _("Email: "),
                            gtk_entry_get_text(GTK_ENTRY
                                               (sa->druid_gui->
                                                entry_new_email)),
                            _("Display mail :"),
                            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                                         (sa->druid_gui->
                                                          check_display_new_email))
                            == TRUE ? _("Yes") : _("No"), _("Name: "),
                            gtk_entry_get_text(GTK_ENTRY
                                               (sa->druid_gui->entry_name)),
                            _("Display name :"),
                            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON
                                                         (sa->druid_gui->
                                                          check_display_name))
                            == TRUE ? _("Yes") : _("No"), _("Postal Code: "),
                            gtk_entry_get_text(GTK_ENTRY
                                               (sa->druid_gui->
                                                entry_postal_code)),
                            _("Country: "),
                            gtk_entry_get_text(GTK_ENTRY
                                               (sa->druid_gui->
                                                combo_entry_country)),
                            _("Computer location: "),
                            gtk_entry_get_text(GTK_ENTRY
                                               (sa->druid_gui->
                                                combo_entry_location)));
    }
    else
    {
        summary = g_strdup_printf("%s\n\n%s%s",
                                  _
                                  ("Here's your existing account mail address. Click on terminate if it is correct."),
                                  _("Email: "),
                                  gtk_entry_get_text(GTK_ENTRY
                                                     (sa->druid_gui->
                                                      entry_existing_email)));
    }

    // Display the summary
    gnome_druid_page_edge_set_text(GNOME_DRUID_PAGE_EDGE
                                   (sa->druid_gui->lastpage), summary);
}


/*
 * new_user_druid_entry_changed
 * This function is called when an entry
 * is changed to check if the next button
 * can be shown
 *
 * Param: the entry
 * Param: sa the setiapplet structure for the applet in use
 */
static void
new_user_druid_entry_changed(GtkWidget * entry,
                             gpointer user_data)
{
    gboolean    error = FALSE;
    setiapplet *sa = (setiapplet *) user_data;

    // Check if we are on page 2
    if(entry == sa->druid_gui->entry_existing_email)
    {
        // Verify that the mail address is valid
        if(is_valid_mail
           ((gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_existing_email)))
           == FALSE)
            error = TRUE;
    }

    // Check if we are on page 3
    if((entry == sa->druid_gui->entry_new_email)
       || (entry == sa->druid_gui->entry_name))
    {
        // Verify that the mail address is valid
        if(is_valid_mail
           ((gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_new_email))) ==
           FALSE)
            error = TRUE;

        // And the name not empty
        if(strlen
           ((gchar *) gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_name)))
           == 0)
            error = TRUE;
    }

    // Check if we are on page 4
    if(entry == sa->druid_gui->entry_postal_code)
    {
        // Verify that the postal code is not empty
        if(strlen
           ((gchar *)
            gtk_entry_get_text(GTK_ENTRY(sa->druid_gui->entry_postal_code))) ==
           0)
            error = TRUE;
    }

    // If there is an error here, hide the next button
    if(!error)
        gnome_druid_set_buttons_sensitive(GNOME_DRUID(sa->druid_gui->druid),
                                          TRUE, TRUE, TRUE, FALSE);
    else
        gnome_druid_set_buttons_sensitive(GNOME_DRUID(sa->druid_gui->druid),
                                          TRUE, FALSE, TRUE, FALSE);
}


/*
 * gui_new_user_druid
 * Create the druid for new user registration
 *
 * Param: sa the setiapplet structure for the applet in use
 */
void
gui_new_user_druid(setiapplet * sa)
{
    GladeXML   *gui = NULL;
    gchar      *file;
    GdkPixbuf  *pixbuf = NULL;

    // Load the druid glade file
    gui = glade_xml_new(GLADE_FILE, "SetiAppletWindowDruid", NULL);
    if(!gui)
    {
        gui_warning("Error loading glade file");
    }

    // Load the logo file
    file =
        gnome_program_locate_file(NULL, GNOME_FILE_DOMAIN_PIXMAP,
                                  "seti_applet/seti_applet-logo-green.png",
                                  TRUE, NULL);
    pixbuf = gdk_pixbuf_new_from_file(file, NULL);
    g_free(file);

    // Display the druid Widget
    sa->druid_gui->window = glade_xml_get_widget(gui, "SetiAppletWindowDruid");
    sa->druid_gui->druid = glade_xml_get_widget(gui, "SetiAppletDruid");
    gtk_widget_show(sa->druid_gui->druid);
    sa->druid_gui->firstpage = glade_xml_get_widget(gui, "druidpagestart1");
    gnome_druid_page_edge_set_logo(GNOME_DRUID_PAGE_EDGE
                                   (sa->druid_gui->firstpage), pixbuf);
    gtk_widget_show(sa->druid_gui->firstpage);
    sa->druid_gui->page1 = glade_xml_get_widget(gui, "druidpagestandard1");
    gnome_druid_page_standard_set_logo(GNOME_DRUID_PAGE_STANDARD
                                       (sa->druid_gui->page1), pixbuf);
    gtk_widget_show(sa->druid_gui->page1);
    sa->druid_gui->page2 = glade_xml_get_widget(gui, "druidpagestandard2");
    gnome_druid_page_standard_set_logo(GNOME_DRUID_PAGE_STANDARD
                                       (sa->druid_gui->page2), pixbuf);
    gtk_widget_show(sa->druid_gui->page2);
    sa->druid_gui->page3 = glade_xml_get_widget(gui, "druidpagestandard3");
    gnome_druid_page_standard_set_logo(GNOME_DRUID_PAGE_STANDARD
                                       (sa->druid_gui->page3), pixbuf);
    gtk_widget_show(sa->druid_gui->page3);
    sa->druid_gui->page4 = glade_xml_get_widget(gui, "druidpagestandard4");
    gnome_druid_page_standard_set_logo(GNOME_DRUID_PAGE_STANDARD
                                       (sa->druid_gui->page4), pixbuf);
    gtk_widget_show(sa->druid_gui->page4);
    sa->druid_gui->lastpage = glade_xml_get_widget(gui, "druidpagefinish1");
    gnome_druid_page_edge_set_logo(GNOME_DRUID_PAGE_EDGE
                                   (sa->druid_gui->lastpage), pixbuf);
    gtk_widget_show(GTK_WIDGET(sa->druid_gui->lastpage));

    // Save some usefuls widgets
    sa->druid_gui->radio_new_account =
        glade_xml_get_widget(gui, "Radio_New_Account");
    sa->druid_gui->entry_new_email =
        glade_xml_get_widget(gui, "entry_new_email");
    sa->druid_gui->entry_existing_email =
        glade_xml_get_widget(gui, "entry_existing_email");
    sa->druid_gui->check_display_new_email =
        glade_xml_get_widget(gui, "check_display_new_email");
    sa->druid_gui->entry_name = glade_xml_get_widget(gui, "entry_name");
    sa->druid_gui->check_display_name =
        glade_xml_get_widget(gui, "check_display_name");
    sa->druid_gui->entry_postal_code =
        glade_xml_get_widget(gui, "entry_postal_code");
    sa->druid_gui->combo_entry_country =
        glade_xml_get_widget(gui, "combo-entry_country");
    sa->druid_gui->combo_entry_location =
        glade_xml_get_widget(gui, "combo-entry_location");

    //      Callback connections
    g_signal_connect(G_OBJECT(sa->druid_gui->druid),
                     "cancel", G_CALLBACK(new_user_druid_cancel), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->lastpage),
                     "finish", G_CALLBACK(new_user_druid_finish), sa);
    g_signal_connect_after(G_OBJECT(sa->druid_gui->page2),
                           "prepare",
                           G_CALLBACK(new_user_druid_standard_prepare), sa);
    g_signal_connect_after(G_OBJECT(sa->druid_gui->page3), "prepare",
                           G_CALLBACK(new_user_druid_standard_prepare), sa);
    g_signal_connect_after(G_OBJECT(sa->druid_gui->page4), "prepare",
                           G_CALLBACK(new_user_druid_standard_prepare), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->lastpage), "prepare",
                     G_CALLBACK(new_user_druid_lastpage_prepare), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->entry_existing_email), "changed",
                     G_CALLBACK(new_user_druid_entry_changed), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->entry_new_email), "changed",
                     G_CALLBACK(new_user_druid_entry_changed), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->entry_name), "changed",
                     G_CALLBACK(new_user_druid_entry_changed), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->entry_postal_code), "changed",
                     G_CALLBACK(new_user_druid_entry_changed), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->page3), "back",
                     G_CALLBACK(new_user_druid_page_back), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->lastpage), "back",
                     G_CALLBACK(new_user_druid_page_back), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->page1), "next",
                     G_CALLBACK(new_user_druid_page_next), sa);
    g_signal_connect(G_OBJECT(sa->druid_gui->page2), "next",
                     G_CALLBACK(new_user_druid_page_next), sa);
}
