#include "petsc.h"
#include "petscfix.h"
/* setup.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "slepceps.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetup_ EPSSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetup_ epssetup
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetinitialvector_ EPSSETINITIALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetinitialvector_ epssetinitialvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetinitialvector_ EPSGETINITIALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetinitialvector_ epsgetinitialvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetleftinitialvector_ EPSSETLEFTINITIALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetleftinitialvector_ epssetleftinitialvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsgetleftinitialvector_ EPSGETLEFTINITIALVECTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsgetleftinitialvector_ epsgetleftinitialvector
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epssetoperators_ EPSSETOPERATORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epssetoperators_ epssetoperators
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsattachdeflationspace_ EPSATTACHDEFLATIONSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsattachdeflationspace_ epsattachdeflationspace
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define epsremovedeflationspace_ EPSREMOVEDEFLATIONSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define epsremovedeflationspace_ epsremovedeflationspace
#endif


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void PETSC_STDCALL  epssetup_(EPS *eps, int *__ierr ){
*__ierr = EPSSetUp(*eps);
}
void PETSC_STDCALL  epssetinitialvector_(EPS *eps,Vec vec, int *__ierr ){
*__ierr = EPSSetInitialVector(*eps,
	(Vec)PetscToPointer((vec) ));
}
void PETSC_STDCALL  epsgetinitialvector_(EPS *eps,Vec *vec, int *__ierr ){
*__ierr = EPSGetInitialVector(*eps,vec);
}
void PETSC_STDCALL  epssetleftinitialvector_(EPS *eps,Vec vec, int *__ierr ){
*__ierr = EPSSetLeftInitialVector(*eps,
	(Vec)PetscToPointer((vec) ));
}
void PETSC_STDCALL  epsgetleftinitialvector_(EPS *eps,Vec *vec, int *__ierr ){
*__ierr = EPSGetLeftInitialVector(*eps,vec);
}
void PETSC_STDCALL  epssetoperators_(EPS *eps,Mat A,Mat B, int *__ierr ){
*__ierr = EPSSetOperators(*eps,
	(Mat)PetscToPointer((A) ),
	(Mat)PetscToPointer((B) ));
}
void PETSC_STDCALL  epsattachdeflationspace_(EPS *eps,int *n,Vec *ds,PetscTruth *ortho, int *__ierr ){
*__ierr = EPSAttachDeflationSpace(*eps,*n,ds,*ortho);
}
void PETSC_STDCALL  epsremovedeflationspace_(EPS *eps, int *__ierr ){
*__ierr = EPSRemoveDeflationSpace(*eps);
}
#if defined(__cplusplus)
}
#endif
