/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "baseguiplus.h"

#ifdef USE_SYSTEM_TRAY

#if QT_VERSION >= 0x040200
#include <Q3PopupMenu>
#else
#include <qpopupmenu.h>
#include "mysystemtrayicon.h"
#endif

#include "myaction.h"
#include "global.h"
#include "images.h"
#include "playlist.h"
//#include "infowindow.h"
#endif


BaseGuiPlus::BaseGuiPlus( QStringList files, QWidget * parent, const char* name,
                          WFlags fl )
	: BaseGui( files, parent, name, fl )
{
#ifdef USE_SYSTEM_TRAY
	mainwindow_visible = true;
	playlist_visible = false;
	//infowindow_visible = false;
	mainwindow_pos = pos();

	#if QT_VERSION >= 0x040200
	tray = new QSystemTrayIcon( Images::icon("logo", 22), this );
	#else
	tray = new MySystemTrayIcon( Images::icon("logo", 22), this );
	#endif

	tray->setToolTip( "SMPlayer" );
	connect( tray, SIGNAL(activated(QSystemTrayIcon::ActivationReason)), 
             this, SLOT(trayIconActivated(QSystemTrayIcon::ActivationReason)));

	quitAct = new MyAction(this, "quit");
    connect( quitAct, SIGNAL(activated()), this, SLOT(quit()) );
	quitAct->addTo( openMenu );

	showTrayAct = new MyAction(this, "show_try_icon" );
	showTrayAct->setToggleAction(true);
	connect( showTrayAct, SIGNAL(toggled(bool)),
             tray, SLOT(setVisible(bool)) );
	showTrayAct->addTo( optionsMenu );

	showAllAct = new MyAction(this, "restore/hide");
	connect( showAllAct, SIGNAL(activated()),
             this, SLOT(toggleShowAll()) );

	context_menu = new QPopupMenu(this);

	showAllAct->addTo( context_menu );
	context_menu->insertSeparator();
	openFileAct->addTo( context_menu );
	recents_menu_id = context_menu->insertItem( "Recents", recentfiles_menu );
	openDVDAct->addTo( context_menu );
	openURLAct->addTo( context_menu );
	context_menu->insertSeparator();
	playOrPauseAct->addTo( context_menu );
	stopAct->addTo( context_menu );
	context_menu->insertSeparator();
	playPrevAct->addTo( context_menu );
	playNextAct->addTo( context_menu );
	context_menu->insertSeparator();
	showPlaylistAct->addTo( context_menu );
	showPreferencesAct->addTo( context_menu );
	context_menu->insertSeparator();
	quitAct->addTo( context_menu );
	
	tray->setContextMenu( context_menu );
#endif

	languageChange();

    loadConfig();
}

BaseGuiPlus::~BaseGuiPlus() {
	saveConfig();
}

void BaseGuiPlus::firstShow() {
	qDebug("BaseGuiPlus::firstShow");
#ifdef USE_SYSTEM_TRAY
	if ( (!showTrayAct->isOn()) || (!initial_files.empty()) || 
         (mainwindow_visible) ) 
	{
		show();
	}
#else
	BaseGui::firstShow();
#endif
}

void BaseGuiPlus::closeEvent( QCloseEvent * e ) {
	qDebug("BaseGuiPlus::closeEvent");
	e->ignore();
	closeWindow();
}

void BaseGuiPlus::closeWindow() {
	qDebug("BaseGuiPlus::closeWindow");
#ifdef USE_SYSTEM_TRAY
	if (tray->isVisible()) {
		//e->ignore();
		exitFullscreen();
		showAll(false); // Hide windows
		if (core->state == PLAYING) core->stop();
		#if QT_VERSION >= 0x040200
		if (pref->balloon_count > 0) {
			tray->showMessage( "SMPlayer", 
				tr("SMPlayer is still running here"), 
        	    QSystemTrayIcon::Information, 3000 );
			pref->balloon_count--;
		}
		#endif
	} else {
		BaseGui::closeWindow();
	}
	//tray->hide();
#else
	BaseGui::closeWindow();
#endif
}

void BaseGuiPlus::quit() {
	qDebug("BaseGuiPlus::quit");
	BaseGui::closeWindow();
}

void BaseGuiPlus::languageChange() {
	BaseGui::languageChange();

#ifdef USE_SYSTEM_TRAY
	quitAct->change( Images::icon("exit"), tr("&Quit") );
	showTrayAct->change( tr("S&how icon in system tray") );
	context_menu->changeItem( recents_menu_id, tr("&Recent files") );
	updateShowAllAct();
#endif
}

void BaseGuiPlus::updateShowAllAct() {
#ifdef USE_SYSTEM_TRAY
	if (isVisible()) 
		showAllAct->change( tr("&Hide") );
	else
		showAllAct->change( tr("&Restore") );
#endif
}

void BaseGuiPlus::saveConfig() {
	qDebug("BaseGuiPlus::saveConfig");

#ifdef USE_SYSTEM_TRAY

	QSettings * set = settings;

	set->beginGroup( "base_gui_plus");

	set->writeEntry( "show_tray_icon", showTrayAct->isOn() );
	set->writeEntry( "mainwindow_visible", isVisible() );

	set->endGroup();

#endif
}

void BaseGuiPlus::loadConfig() {
	qDebug("BaseGuiPlus::loadConfig");

#ifdef USE_SYSTEM_TRAY

	QSettings * set = settings;

	set->beginGroup( "base_gui_plus");

	bool show_tray_icon = set->readBoolEntry( "show_tray_icon", false);
	showTrayAct->setOn( show_tray_icon );
	//tray->setVisible( show_tray_icon );

	mainwindow_visible = set->readBoolEntry("mainwindow_visible", true);

	set->endGroup();

	updateShowAllAct();
#endif
}


void BaseGuiPlus::trayIconActivated(QSystemTrayIcon::ActivationReason reason) {
#ifdef USE_SYSTEM_TRAY
	qDebug("DefaultGui::trayIconActivated: %d", reason);

	updateShowAllAct();

	if (reason == QSystemTrayIcon::Trigger) {
		toggleShowAll();
	}
	else
	if (reason == QSystemTrayIcon::MiddleClick) {
		core->pause();
	}
#endif
}

void BaseGuiPlus::toggleShowAll() {
#ifdef USE_SYSTEM_TRAY
	showAll( !isVisible() );
#endif
}

void BaseGuiPlus::showAll(bool b) {
#ifdef USE_SYSTEM_TRAY
	if (!b) {
		// Hide all
		mainwindow_pos = pos();
		hide();

		playlist_visible = playlist->isVisible();
		playlist_pos = playlist->pos();
		playlist->hide();

		/*
		infowindow_visible = info_window->isVisible();
		infowindow_pos = info_window->pos();
		info_window->hide();
		*/
	} else {
		// Show all
		move(mainwindow_pos);
		show();

		if (playlist_visible) {
			playlist->move(playlist_pos);
			playlist->show();
		}

		/*
		if (infowindow_visible) {
			info_window->show();
			info_window->move(infowindow_pos);
		}
		*/
	}
	updateShowAllAct();
#endif
}

void BaseGuiPlus::resizeWindow(int w, int h) {
    qDebug("BaseGuiPlus::resizeWindow: %d, %d", w, h);

#ifdef USE_SYSTEM_TRAY
	if ( (tray->isVisible()) && (!isVisible()) ) showAll(true);
#endif

	BaseGui::resizeWindow(w, h );
}

void BaseGuiPlus::updateMediaInfo() {
    qDebug("BaseGuiPlus::updateMediaInfo");
	BaseGui::updateMediaInfo();

#ifdef USE_SYSTEM_TRAY
	tray->setToolTip( caption() );
#endif
}

void BaseGuiPlus::setWindowCaption(const QString & title) {
#ifdef USE_SYSTEM_TRAY
	tray->setToolTip( title );
#endif
	BaseGui::setWindowCaption( title );
}

