/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _BASEGUIPLUS_H_
#define _BASEGUIPLUS_H_

#include "basegui.h"


#if QT_VERSION >= 0x040200
#define USE_SYSTEM_TRAY
#else
#ifdef KDE_SUPPORT
#define USE_SYSTEM_TRAY
#endif
#endif


#if QT_VERSION >= 0x040200
#include <QSystemTrayIcon>
#include <qpoint.h>
class Q3PopupMenu;
#else
class QPopupMenu;
class MySystemTrayIcon;
class QSystemTrayIcon {
public:
	enum ActivationReason { Unknown, Context, DoubleClick, Trigger, MiddleClick };
};
#endif


class BaseGuiPlus : public BaseGui
{
	Q_OBJECT

public:
	BaseGuiPlus( QStringList files, QWidget* parent = 0, const char* name = 0, 
                 WFlags fl = WType_TopLevel );
	~BaseGuiPlus();

protected:
	void loadConfig();
	void saveConfig();
	void updateShowAllAct();
	virtual void closeEvent( QCloseEvent * e );

protected slots:
	// Reimplemented methods
	virtual void languageChange();
	virtual void closeWindow();
	virtual void setWindowCaption(const QString & title);
	virtual void firstShow();
	virtual void resizeWindow(int w, int h);
	virtual void updateMediaInfo();
	// New
	virtual void trayIconActivated(QSystemTrayIcon::ActivationReason);
	virtual void toggleShowAll();
	virtual void showAll(bool b);
	virtual void quit();


protected:
	#ifdef USE_SYSTEM_TRAY

	#if QT_VERSION >= 0x040200
	QSystemTrayIcon * tray;
	Q3PopupMenu * context_menu;
	#else
	MySystemTrayIcon * tray;
	QPopupMenu * context_menu;
	#endif

	MyAction * quitAct;
	MyAction * showTrayAct;
	MyAction * showAllAct;

	int recents_menu_id;

	// To save state
	QPoint mainwindow_pos;
	bool mainwindow_visible;

	QPoint playlist_pos;
	bool playlist_visible;

	//QPoint infowindow_pos;
	//bool infowindow_visible;
	#endif
};

#endif
