/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* This file is based on the "small client-server example" from Qt */
/* Copyright (C) 1992-2000 Trolltech AS. */


#ifndef _CLIENT_H_
#define _CLIENT_H_

#include <qobject.h>
#include <qstring.h>

class QSocket;
class QTimer;

class MyClient : public QObject
{
	Q_OBJECT

public:
    MyClient( Q_UINT16 port, QObject * parent = 0, const char * name = 0 );
	~MyClient();

public slots:
	void sendToServer(QString text);
	void closeConnection();

signals:
	void connected();
	void notConnected();
	void serverIdentified();
	void connectionClosed();
	void unknownServer();
	void serverDontRespond();

private slots:
	void socketReadyRead();
	void socketConnected();
	void socketConnectionClosed();
	void socketClosed();
	void socketError( int e );

private:
    QSocket *socket;
	bool identified_server;
	bool sent_unknown_server_signal;

	QTimer * timer;
};

#endif
