/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "filepropertiesdialog.h"
#include <qlistbox.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include "images.h"
#include "infofile.h"

FilePropertiesDialog::FilePropertiesDialog( 
	QWidget* parent, const char* name, bool modal, WFlags fl )
		: FilePropertiesDialogBase(parent, name, modal, fl)
{
	codecs_set = FALSE;

	/*
	vc_listbox->insertItem( tr("<default>") );
	ac_listbox->insertItem( tr("<default>") );
	demuxer_listbox->insertItem( tr("<default>") );
	*/

	languageChange();
}

FilePropertiesDialog::~FilePropertiesDialog() {
}

void FilePropertiesDialog::setMediaData(MediaData md) {
	media_data = md;
	showInfo();
}

void FilePropertiesDialog::showInfo() {
	InfoFile info;
	info_edit->setText( info.getInfo(media_data) );
}

void FilePropertiesDialog::languageChange() {
	FilePropertiesDialogBase::languageChange();

	setIcon( Images::icon("logo") );

	showInfo();
	/* adjustSize(); */
}

void FilePropertiesDialog::accept() {
	hide();
	setResult( QDialog::Accepted );
	emit applyButtonPressed();
}

void FilePropertiesDialog::apply() {
	setResult( QDialog::Accepted );
	emit applyButtonPressed();
}

void FilePropertiesDialog::setCodecs(InfoList vc, InfoList ac, InfoList demuxer) 
{
	vclist = vc;
	aclist = ac;
	demuxerlist = demuxer;

	InfoList::iterator it;

	for ( it = vclist.begin(); it != vclist.end(); ++it ) {
		vc_listbox->insertItem( (*it).name() +" - "+ (*it).desc() );
	}

	for ( it = aclist.begin(); it != aclist.end(); ++it ) {
		ac_listbox->insertItem( (*it).name() +" - "+ (*it).desc() );
	}

	for ( it = demuxerlist.begin(); it != demuxerlist.end(); ++it ) {
		demuxer_listbox->insertItem( (*it).name() +" - "+ (*it).desc() );
	}

	codecs_set = TRUE;	
}

void FilePropertiesDialog::setDemuxer(QString demuxer, QString original_demuxer) {
	qDebug("FilePropertiesDialog::setDemuxer");
	if (!original_demuxer.isEmpty()) orig_demuxer = original_demuxer;
	int pos = find(demuxer, demuxerlist );
	if (pos != -1) demuxer_listbox->setCurrentItem(pos);

	qDebug(" * demuxer: '%s', pos: %d", demuxer.utf8().data(), pos );
}

QString FilePropertiesDialog::demuxer() {
	int pos = demuxer_listbox->currentItem();
	if ( pos < 0 )
		return "";
	else
		return demuxerlist[pos].name();
}

void FilePropertiesDialog::setVideoCodec(QString vc, QString original_vc) {
	qDebug("FilePropertiesDialog::setVideoCodec");
	if (!original_vc.isEmpty()) orig_vc = original_vc;
	int pos = find(vc, vclist );
	if (pos != -1) vc_listbox->setCurrentItem(pos);

	qDebug(" * vc: '%s', pos: %d", vc.utf8().data(), pos );
}

QString FilePropertiesDialog::videoCodec() {
	int pos = vc_listbox->currentItem();
	if ( pos < 0 )
		return "";
	else
		return vclist[pos].name();
}

void FilePropertiesDialog::setAudioCodec(QString ac, QString original_ac) {
	qDebug("FilePropertiesDialog::setAudioCodec");
	if (!original_ac.isEmpty()) orig_ac = original_ac;
	int pos = find(ac, aclist );
	if (pos != -1) ac_listbox->setCurrentItem(pos);

	qDebug(" * ac: '%s', pos: %d", ac.utf8().data(), pos );
}

QString FilePropertiesDialog::audioCodec() {
	int pos = ac_listbox->currentItem();
	if ( pos < 0 )
		return "";
	else
		return aclist[pos].name();
}

void FilePropertiesDialog::resetDemuxer() {
	setDemuxer( orig_demuxer );
}

void FilePropertiesDialog::resetAC() {
	setAudioCodec( orig_ac );
}

void FilePropertiesDialog::resetVC() {
	setVideoCodec( orig_vc );
}

int FilePropertiesDialog::find(QString s, InfoList &list) {
	qDebug("FilePropertiesDialog::find");

	int n=0;
	InfoList::iterator it;

	for ( it = list.begin(); it != list.end(); ++it ) {
		//qDebug(" * item: '%s', s: '%s'", (*it).name().utf8().data(), s.utf8().data());
		if ((*it).name() == s) return n;
		n++;
	}
	return -1;
}

void FilePropertiesDialog::setMplayerAdditionalArguments(QString args) {
	mplayer_args_edit->setText(args);
}

QString FilePropertiesDialog::mplayerAdditionalArguments() {
	return mplayer_args_edit->text();
}

void FilePropertiesDialog::setMplayerAdditionalVideoFilters(QString s) {
	mplayer_vfilters_edit->setText(s);
}

QString FilePropertiesDialog::mplayerAdditionalVideoFilters() {
	return mplayer_vfilters_edit->text();
}

void FilePropertiesDialog::setMplayerAdditionalAudioFilters(QString s) {
	mplayer_afilters_edit->setText(s);
}

QString FilePropertiesDialog::mplayerAdditionalAudioFilters() {
	return mplayer_afilters_edit->text();
}
