/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "floatingcontrol.h"

#include <qtoolbutton.h>
#include "timeslider.h"
#include "qt3_4_compat.h"

#include <qlayout.h>
#include "images.h"
#include <qiconset.h>
#include <qlcdnumber.h>
#include <qlabel.h>


class MyToolButton : public QToolButton {
public:
	MyToolButton ( QWidget * parent, const char * name = 0 );
};

MyToolButton::MyToolButton( QWidget * parent, const char * name )
	: QToolButton(parent, name) 
{
	setAutoRaise(true);
/*
#if QT_VERSION >= 0x040000
	setUsesBigPixmap(true);
#endif
*/
}


FloatingControl::FloatingControl( QWidget * parent, const char * name)
	: QWidget( parent, name, Qt::WType_TopLevel | Qt::WStyle_Customize |
                             Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop | 
                             Qt::WX11BypassWM )
{
	play = new MyToolButton(this, "play");
	pause = new MyToolButton(this, "pause");
	stop = new MyToolButton(this, "stop");

	rewind3 = new MyToolButton(this, "rewind3");
	rewind2 = new MyToolButton(this, "rewind2");
	rewind1 = new MyToolButton(this, "rewind1");

	time = new TimeSlider(this, "time" );

	forward1 = new MyToolButton(this, "forward1");
	forward2 = new MyToolButton(this, "forward2");
	forward3 = new MyToolButton(this, "forward3");

#if NEW_CONTROLWIDGET
	time_label = new QLabel(this, "time_label" );
	time_label->setAlignment(Qt::AlignVCenter | Qt::AlignHCenter);
    #if QT_VERSION >= 0x040000
	time_label->setAutoFillBackground(TRUE);
	#endif
	time_label->setPaletteBackgroundColor( QColor(0,0,0) );
    time_label->setPaletteForegroundColor( QColor(255,255,255) );
	time_label->setText( "00:00:00" );
	time_label->setFrameShape( QFrame::Panel );
	time_label->setFrameShadow( QFrame::Sunken );
#else
	lcd = new QLCDNumber(this, "lcd" );
	lcd->setNumDigits(10); // maximum time with 10 digits is 9999:59:59
	lcd->setFrameShape( QFrame::WinPanel );
	lcd->setFrameShadow( QFrame::Sunken );
    #if QT_VERSION >= 0x040000
	lcd->setAutoFillBackground(TRUE);
	#endif
	lcd->setPaletteBackgroundColor( QColor(0,0,0) );
	lcd->setPaletteForegroundColor( QColor(200,200,200) );
	lcd->setSegmentStyle( QLCDNumber::Flat );
	lcd->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed);
#endif

	fullscreen = new MyToolButton(this, "mute");
	fullscreen->setToggleButton(true);

	mute = new MyToolButton(this, "mute");
	mute->setToggleButton(true);

	volume = new MySlider(this, "volume" );
	volume->setTickmarks( QSlider::Below );
	volume->setTickInterval( 10 );
	volume->setLineStep( 1 );
	volume->setPageStep( 10 );
	volume->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed);

	// No focus on widgets
	rewind3->setFocusPolicy( NOFOCUS );
	rewind2->setFocusPolicy( NOFOCUS );
	rewind1->setFocusPolicy( NOFOCUS );

	forward1->setFocusPolicy( NOFOCUS );
	forward2->setFocusPolicy( NOFOCUS );
	forward3->setFocusPolicy( NOFOCUS );

	play->setFocusPolicy( NOFOCUS );
	pause->setFocusPolicy( NOFOCUS );
	stop->setFocusPolicy( NOFOCUS );
#if !NEW_CONTROLWIDGET
	lcd->setFocusPolicy( NOFOCUS );
#endif
	fullscreen->setFocusPolicy( NOFOCUS );
	mute->setFocusPolicy( NOFOCUS );
	volume->setFocusPolicy( NOFOCUS );

	// Layout
#if NEW_CONTROLWIDGET
	QBoxLayout * l = new QHBoxLayout(this, 2, 1);
	l->addWidget( play );
	l->addWidget( pause );
	l->addWidget( stop );
	l->addSpacing( 10 );
	l->addWidget( rewind3 );
	l->addWidget( rewind2 );
	l->addWidget( rewind1 );
	l->addWidget( time );
	l->addWidget( forward1 );
	l->addWidget( forward2 );
	l->addWidget( forward3 );
	l->addSpacing( 10 );
	l->addWidget( fullscreen );
	l->addWidget( mute );
	l->addWidget( volume );
	l->addSpacing( 10 );
	l->addWidget( time_label );
#else
	QBoxLayout * l1 = new QHBoxLayout(0,0,0);
	l1->addWidget( rewind3 );
	l1->addWidget( rewind2 );
	l1->addWidget( rewind1 );
	l1->addWidget( time );
	l1->addWidget( forward1 );
	l1->addWidget( forward2 );
	l1->addWidget( forward3 );

	QSpacerItem * spacer1 = new QSpacerItem( 20, 10, QSizePolicy::Expanding,
                                             QSizePolicy::Minimum );

	QSpacerItem * spacer2 = new QSpacerItem( 20, 10, QSizePolicy::Expanding,
                                             QSizePolicy::Minimum );

	QBoxLayout * l2 = new QHBoxLayout(0,0,0);
	l2->addWidget( play );
	l2->addWidget( pause );
	l2->addWidget( stop );
	l2->addItem( spacer1 );
	l2->addWidget( lcd );
	l2->addItem( spacer2 );
	l2->addWidget( fullscreen );
	l2->addWidget( mute );
	l2->addWidget( volume );

	QBoxLayout * l = new QVBoxLayout(this, 4, 1);
	l->addLayout(l1);
	l->addLayout(l2);
#endif

	languageChange();

	setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed);
	adjustSize();
}


FloatingControl::~FloatingControl()
{
}

void FloatingControl::languageChange() {
	int size = 22;

	play->setPixmap( Images::icon("play", size) );
	pause->setPixmap( Images::icon("pause", size) );
	stop->setPixmap( Images::icon("stop", size) );

	forward1->setPixmap( Images::icon("forward10s", size) );
	forward2->setPixmap( Images::icon("forward1m", size) );
	forward3->setPixmap( Images::icon("forward10m", size) );

	rewind1->setPixmap( Images::icon("rewind10s", size) );
	rewind2->setPixmap( Images::icon("rewind1m", size) );
	rewind3->setPixmap( Images::icon("rewind10m", size) );

	fullscreen->setPixmap( Images::icon("fullscreen", size) );

	QIconSet icset( Images::icon("volume", size) );
	icset.setPixmap( Images::icon("mute", size), QIconSet::Automatic,
                     QIconSet::Normal, QIconSet::On  );
	mute->setIconSet( icset );
}
