/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "global.h"
#include "constants.h"
#include <qsettings.h>
#include "preferences.h"
#include "translator.h"
#include <qapplication.h>

QSettings * settings;
Preferences * pref;
Translator * translator;


void global_init(const QString & ini_path) {
	qDebug("global_init");

	// Translator
	translator = new Translator;

	// settings
#if QT_VERSION >= 0x040000
	if (!ini_path.isEmpty()) {
		settings = new QSettings( ini_path + "/smplayer.ini",
                                  QSettings::IniFormat );
	}
	else {
		settings = new QSettings(QSettings::IniFormat, QSettings::UserScope,
    	                         QString(COMPANY), QString(PROGRAM) );
	}
#else
	settings = new QSettings(QSettings::Ini);
	settings->beginGroup( "/" + QString(PROGRAM) +"/" );
#endif

	// Preferences
	pref = new Preferences;
}

void global_end() {
	qDebug("global_end");

	// delete
	delete pref;
	pref = 0;

	// settings
	#if QT_VERSION < 0x040000
	settings->endGroup();
	#endif

	delete settings;
	delete translator;
}
