/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "logwindow.h"
#include <qtextbrowser.h>
#include "filedialog.h"
#include <qfile.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <qfileinfo.h>
#include <qpushbutton.h>

#include "images.h"

LogWindow::LogWindow( QWidget* parent, const char* name )
	: LogWindowBase(parent, name, Qt::WType_TopLevel ) 
{
	browser->setFont( QFont("fixed") );

	languageChange();
}

LogWindow::~LogWindow() {
}

void LogWindow::languageChange() {
	LogWindowBase::languageChange();

	save_button->setText("");
	copy_button->setText("");

	save_button->setPixmap( Images::icon("save") );
	copy_button->setPixmap( Images::icon("copy") );

	setIcon( Images::icon("logo") );
}


void LogWindow::setText(QString log) {
	browser->setText(log);
}

QString LogWindow::text() {
	return browser->text();
}

void LogWindow::copyText() {
	browser->selectAll();
	browser->copy();
}

void LogWindow::save() {
	QString s = MyFileDialog::getSaveFileName(
                    "",
                    "Logs (*.log *.txt)",
                    this,
                    "save file dialog",
                    tr("Choose a filename to save under") );

	if (!s.isEmpty()) {
		if (QFileInfo(s).exists()) {
			int res =QMessageBox::question( this, 
                                   tr("Confirm overwrite?"),
                                   tr("The file already exists.\n"
                                      "Do you want to overwrite?"),
                                   QMessageBox::Yes,
                                   QMessageBox::No,
                                   QMessageBox::NoButton);
			if (res == QMessageBox::No ) {
				return;
			}
		}

		QFile file( s );
		if ( file.open( IO_WriteOnly ) ) {
	        QTextStream stream( &file );
    		stream << browser->text();
	        file.close();
	    } else {
			// Error opening file
			qDebug("LogWindow::save: error saving file");
			QMessageBox::warning ( this, 
                                   tr("Error saving file"), 
                                   tr("The log couldn't be saved"),
                                   QMessageBox::Ok, 
                                   QMessageBox::NoButton, 
                                   QMessageBox::NoButton );

		}
	}
}

