/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "mediasettings.h"
#include "preferences.h"
#include "global.h"
#include <qsettings.h>

MediaSettings::MediaSettings() {
	reset();
}

MediaSettings::~MediaSettings() {
}

void MediaSettings::reset() {
	current_sec = 0;
	current_sub_id = NoneSelected;
	current_audio_id = NoneSelected;
	current_title_id = NoneSelected;
	current_chapter_id = NoneSelected;
	current_angle_id = NoneSelected;
	letterbox = NoLetterbox;
	aspect_ratio_id = AspectAuto;
	//fullscreen = FALSE;
	volume = pref->initial_volume;
	mute = false;
	external_subtitles = "";
	external_audio = "";
	sub_delay=0;
	audio_delay=0;
	sub_pos = pref->initial_sub_pos; // 100% by default

	brightness = pref->initial_brightness;
	contrast = pref->initial_contrast;
	gamma = pref->initial_gamma;
	hue = pref->initial_hue;
	saturation = pref->initial_saturation;

	speed = 1.0;

	phase_filter = FALSE;
    current_denoiser = NoDenoise;
    deblock_filter = FALSE;
	dering_filter = FALSE;
	noise_filter = FALSE;
	postprocessing_filter = FALSE;

	current_deinterlacer = NoDeinterlace;
	panscan_filter = "";
	crop_43to169_filter = "";
    karaoke_filter = FALSE;
	extrastereo_filter = FALSE;
	volnorm_filter = false;

	audio_use_channels = ChDefault; // (0)
	stereo_mode = Stereo; // (0)

	panscan_factor = pref->initial_panscan_factor; // 1.0;

	starting_time = -1; // Not set yet.

	forced_demuxer="";
    forced_video_codec="";
    forced_audio_codec="";

	original_demuxer="";
    original_video_codec="";
    original_audio_codec="";

	mplayer_additional_options="";
	mplayer_additional_video_filters="";
	mplayer_additional_audio_filters="";

	win_width=0;
	win_height=0;
}

double MediaSettings::win_aspect() {
	return (double) win_width / win_height;
}

void MediaSettings::list() {
	qDebug("MediaSettings::list");

	qDebug("  current_sec: %f", current_sec);
	qDebug("  current_sub_id: %d", current_sub_id);
	qDebug("  current_audio_id: %d", current_audio_id);
	qDebug("  current_title_id: %d", current_title_id);
	qDebug("  current_chapter_id: %d", current_chapter_id);
	qDebug("  current_angle_id: %d", current_angle_id);
	qDebug("  letterbox: %d", letterbox);
	qDebug("  aspect_ratio_id: %d", aspect_ratio_id);
	//qDebug("  fullscreen: %d", fullscreen);
	qDebug("  volume: %d", volume);
	qDebug("  mute: %d", mute);
	qDebug("  external_subtitles: '%s'", external_subtitles.utf8().data());
	qDebug("  external_audio: '%s'", external_audio.utf8().data());
	qDebug("  sub_delay: %d", sub_delay);
	qDebug("  audio_delay: %d", sub_delay);
	qDebug("  sub_pos: %d", sub_pos);

	qDebug("  brightness: %d", brightness);
	qDebug("  contrast: %d", contrast);
	qDebug("  gamma: %d", gamma);
	qDebug("  hue: %d", hue);
	qDebug("  saturation: %d", saturation);

	qDebug("  speed: %f", speed);

	qDebug("  phase_filter: %d", phase_filter);
	qDebug("  current_denoiser: %d", current_denoiser);
	qDebug("  deblock_filter: %d", deblock_filter);
	qDebug("  dering_filter: %d", dering_filter);
	qDebug("  noise_filter: %d", noise_filter);
	qDebug("  postprocessing_filter: %d", postprocessing_filter);

	qDebug("  current_deinterlacer: %d", current_deinterlacer);
	qDebug("  panscan_filter: '%s'", panscan_filter.utf8().data());
	qDebug("  crop_43to169_filter: '%s'", crop_43to169_filter.utf8().data());
	qDebug("  karaoke_filter: %d", karaoke_filter);
	qDebug("  extrastereo_filter: %d", extrastereo_filter);
	qDebug("  volnorm_filter: %d", volnorm_filter);

	qDebug("  audio_use_channels: %d", audio_use_channels);
	qDebug("  stereo_mode: %d", stereo_mode);

	qDebug("  panscan_factor: %f", panscan_factor);

	qDebug("  forced_demuxer: '%s'", forced_demuxer.utf8().data());
	qDebug("  forced_video_codec: '%s'", forced_video_codec.utf8().data());
	qDebug("  forced_audio_codec: '%s'", forced_video_codec.utf8().data());

	qDebug("  original_demuxer: '%s'", original_demuxer.utf8().data());
	qDebug("  original_video_codec: '%s'", original_video_codec.utf8().data());
	qDebug("  original_audio_codec: '%s'", original_video_codec.utf8().data());

	qDebug("  mplayer_additional_options: '%s'", mplayer_additional_options.utf8().data());
	qDebug("  mplayer_additional_video_filters: '%s'", mplayer_additional_video_filters.utf8().data());
	qDebug("  mplayer_additional_audio_filters: '%s'", mplayer_additional_audio_filters.utf8().data());

	qDebug("  win_width: %d", win_width);
	qDebug("  win_height: %d", win_height); 
	qDebug("  win_aspect(): %f", win_aspect()); 

	qDebug("  starting_time: %f", starting_time);
}

void MediaSettings::save() {
	qDebug("MediaSettings::save");

	QSettings * set = settings;

	/*set->beginGroup( "mediasettings" );*/

	set->writeEntry( "current_sec", current_sec );
	set->writeEntry( "current_sub_id", current_sub_id );
	set->writeEntry( "current_audio_id", current_audio_id );
	set->writeEntry( "current_title_id", current_title_id );
	set->writeEntry( "current_chapter_id", current_chapter_id );
	set->writeEntry( "current_angle_id", current_angle_id );
	set->writeEntry( "letterbox", letterbox );
	set->writeEntry( "aspect_ratio_id", aspect_ratio_id );
	//set->writeEntry( "fullscreen", fullscreen );
	set->writeEntry( "volume", volume );
	set->writeEntry( "mute", mute );
	set->writeEntry( "external_subtitles", external_subtitles );
	set->writeEntry( "external_audio", external_audio );
	set->writeEntry( "sub_delay", sub_delay);
	set->writeEntry( "audio_delay", audio_delay);
	set->writeEntry( "sub_pos", sub_pos);

	set->writeEntry( "brightness", brightness);
	set->writeEntry( "contrast", contrast);
	set->writeEntry( "gamma", gamma);
	set->writeEntry( "hue", hue);
	set->writeEntry( "saturation", saturation);

	set->writeEntry( "speed", speed);

	set->writeEntry( "phase_filter", phase_filter);
	set->writeEntry( "current_denoiser", current_denoiser);
	set->writeEntry( "deblock_filter", deblock_filter);
	set->writeEntry( "dering_filter", dering_filter);
	set->writeEntry( "noise_filter", noise_filter);
	set->writeEntry( "postprocessing_filter", postprocessing_filter);

	set->writeEntry( "current_deinterlacer", current_deinterlacer);
	set->writeEntry( "panscan_filter", panscan_filter);
	set->writeEntry( "crop_43to169_filter", crop_43to169_filter);
	set->writeEntry( "karaoke_filter", karaoke_filter);
	set->writeEntry( "extrastereo_filter", extrastereo_filter);
	set->writeEntry( "volnorm_filter", volnorm_filter);

	set->writeEntry( "audio_use_channels", audio_use_channels);
	set->writeEntry( "stereo_mode", stereo_mode);

	set->writeEntry( "panscan_factor", panscan_factor);

	set->writeEntry( "forced_demuxer", forced_demuxer);
	set->writeEntry( "forced_video_codec", forced_video_codec);
	set->writeEntry( "forced_audio_codec", forced_audio_codec);

	set->writeEntry( "original_demuxer", original_demuxer);
	set->writeEntry( "original_video_codec", original_video_codec);
	set->writeEntry( "original_audio_codec", original_audio_codec);

	set->writeEntry( "mplayer_additional_options", mplayer_additional_options);
	set->writeEntry( "mplayer_additional_video_filters", mplayer_additional_video_filters);
	set->writeEntry( "mplayer_additional_audio_filters", mplayer_additional_audio_filters);

	set->writeEntry( "win_width", win_width );
	set->writeEntry( "win_height", win_height );

	set->writeEntry( "starting_time", starting_time );

	/*set->endGroup();*/
}

void MediaSettings::load() {
	qDebug("MediaSettings::load");

	QSettings * set = settings;

	/*set->beginGroup( "mediasettings" );*/

	current_sec = set->readDoubleEntry( "current_sec", current_sec);
	current_sub_id = set->readNumEntry( "current_sub_id", current_sub_id );
	current_audio_id = set->readNumEntry( "current_audio_id", current_audio_id );
	current_title_id = set->readNumEntry( "current_title_id", current_title_id );
	current_chapter_id = set->readNumEntry( "current_chapter_id", current_chapter_id );
	current_angle_id = set->readNumEntry( "current_angle_id", current_angle_id );
	letterbox = (LetterboxType) set->readNumEntry( "letterbox", letterbox );
	aspect_ratio_id = set->readNumEntry( "aspect_ratio_id", aspect_ratio_id );
	//fullscreen = set->readBoolEntry( "fullscreen", fullscreen );
	volume = set->readNumEntry( "volume", volume );
	mute = set->readBoolEntry( "mute", mute );
	external_subtitles = set->readEntry( "external_subtitles", external_subtitles );
	external_audio = set->readEntry( "external_audio", external_audio );
	sub_delay = set->readNumEntry( "sub_delay", sub_delay);
	audio_delay = set->readNumEntry( "audio_delay", audio_delay);
	sub_pos = set->readNumEntry( "sub_pos", sub_pos);

	brightness = set->readNumEntry( "brightness", brightness);
	contrast = set->readNumEntry( "contrast", contrast);
	gamma = set->readNumEntry( "gamma", gamma);
	hue = set->readNumEntry( "hue", hue);
	saturation = set->readNumEntry( "saturation", saturation);

	speed = set->readDoubleEntry( "speed", speed );

	phase_filter = set->readBoolEntry( "phase_filter", phase_filter );
	current_denoiser = set->readNumEntry( "current_denoiser", current_denoiser);
	deblock_filter = set->readBoolEntry( "deblock_filter", deblock_filter);
	dering_filter = set->readBoolEntry( "dering_filter", dering_filter);
	noise_filter = set->readBoolEntry( "noise_filter", noise_filter);
	postprocessing_filter = set->readBoolEntry( "postprocessing_filter", postprocessing_filter);

	current_deinterlacer = set->readNumEntry( "current_deinterlacer", current_deinterlacer );
	panscan_filter = set->readEntry( "panscan_filter", panscan_filter);
	crop_43to169_filter = set->readEntry( "crop_43to169_filter", crop_43to169_filter);
	karaoke_filter = set->readBoolEntry( "karaoke_filter", karaoke_filter);
	extrastereo_filter = set->readBoolEntry( "extrastereo_filter", extrastereo_filter);
	volnorm_filter = set->readBoolEntry( "volnorm_filter", volnorm_filter);

	audio_use_channels = set->readNumEntry( "audio_use_channels", audio_use_channels);
	stereo_mode = set->readNumEntry( "stereo_mode", stereo_mode);

	panscan_factor = set->readDoubleEntry( "panscan_factor", panscan_factor);

	forced_demuxer = set->readEntry( "forced_demuxer", forced_demuxer);
	forced_video_codec = set->readEntry( "forced_video_codec", forced_video_codec);
	forced_audio_codec = set->readEntry( "forced_audio_codec", forced_audio_codec);

	original_demuxer = set->readEntry( "original_demuxer", original_demuxer);
	original_video_codec = set->readEntry( "original_video_codec", original_video_codec);
	original_audio_codec = set->readEntry( "original_audio_codec", original_audio_codec);

	mplayer_additional_options = set->readEntry( "mplayer_additional_options", mplayer_additional_options);
	mplayer_additional_video_filters = set->readEntry( "mplayer_additional_video_filters", mplayer_additional_video_filters);
	mplayer_additional_audio_filters = set->readEntry( "mplayer_additional_audio_filters", mplayer_additional_audio_filters);

	win_width = set->readNumEntry( "win_width", win_width );
	win_height = set->readNumEntry( "win_height", win_height );

	starting_time = set->readDoubleEntry( "starting_time", starting_time );

	/*set->endGroup();*/
}

