/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "preferences.h"
#include "global.h"
#include <qsettings.h>
#include <qfileinfo.h>
#include <qregexp.h>

Preferences::Preferences() {
	reset();
	load();
}

Preferences::~Preferences() {
	save();
}

void Preferences::reset() {
#ifdef Q_OS_WIN
	mplayer_bin= "mplayer/mplayer.exe";
#else
	mplayer_bin = "mplayer";
#endif

	QFileInfo fi(mplayer_bin);
	if (fi.exists()) {
		mplayer_bin = fi.absFilePath();
		qDebug("mplayer_bin: '%s'", mplayer_bin.utf8().data());
	}

	use_fontconfig = FALSE;
	use_ass_subtitles = FALSE;
	font_file = "";
	font_name = "";
	subcp = "ISO-8859-1";
	font_autoscale = 1;
	font_textscale = 5;
	autoload_sub = TRUE;
	subfuzziness = 1;
	ass_color = 0xFFFF00;
    ass_border_color = 0x000000;
	//ass_styles = "Bold=1,Outline=2,Shadow=2";
	ass_styles = "";

	osd = None;

	vo = ""; 
	ao = "";

	color_key = 0x020202;

/*
#ifdef Q_OS_WIN
	dvd_device="E:";
	cdrom_device="E:";
#else
	dvd_device="/dev/dvd";
	cdrom_device="/dev/cdrom";
#endif
*/

	dvd_device = "";
	cdrom_device = "";

	// MPlayer 1.0rc1 require restart, new versions don't
	audio_change_requires_restart = FALSE; // Now we need a svn mplayer
	fast_chapter_change = FALSE;

	use_cache = false;
	cache = 2000;

	use_mplayer_window = FALSE;

	monitor_aspect=""; // Autodetect
	
	latest_dir="";
	last_url="";
	last_dvd_directory="";

	mplayer_verbose="";

	resize_method = Always;
	disable_screensaver = TRUE;

	screenshot_directory="";
	subtitles_on_screenshots = TRUE;

	use_soft_video_eq = FALSE;
	use_soft_vol = FALSE;
	use_volnorm = false;
    softvol_max = 110; // 110 = default value in mplayer


	audio_lang = "";
	subtitle_lang = "";

	use_hwac3 = false;

	vcd_initial_title = 2; // Most VCD's start at title #2

	initial_volume = 40;
	initial_contrast = 0;
	initial_brightness = 0;
	initial_hue = 0;
	initial_saturation = 0;
	initial_gamma = 0;

	initial_panscan_factor = 1.0;
	initial_sub_pos = 100; // 100%

	mplayer_additional_options="";
    mplayer_additional_video_filters="";
    mplayer_additional_audio_filters="";

	priority = AboveNormal; // Option only for windows
	frame_drop = FALSE;
	hard_frame_drop = FALSE;
	autosync = FALSE;
	autosync_factor = 100;

	dont_remember_media_settings = FALSE;
	dont_remember_time_pos = FALSE;

#if STYLE_SWITCHING
	style="";
#endif

	fullscreen = FALSE;
	start_in_fullscreen = FALSE;

	compact_mode = FALSE;
	stay_on_top = FALSE;
	size_factor = 100; // 100%

	show_frame_counter = FALSE;

	use_postprocessing = false;
	autoq = 6;

	loop = FALSE;

	use_single_instance = FALSE;
	connection_port = 8000;

	mouse_left_click_function = "";
	mouse_double_click_function = "fullscreen";
	wheel_function = Seeking;

	recents_max_items = 10;

	seeking1 = 10;
	seeking2 = 60;
	seeking3 = 10*60;
	seeking4 = 30;

	log_mplayer = TRUE;
	log_smplayer = TRUE;
	log_filter = ".*";

	language = "";
	iconset = "";

	always_clear_background = true;

	rx_endoffile = "Exiting... \\(End of file\\)";
	rx_novideo = "Video: no video";

	balloon_count = 5;

	dont_use_eq_options = false;

	use_subfont = false;
}

void Preferences::save() {
	qDebug("Preferences::save");

	QSettings * set = settings;

	set->beginGroup( "preferences");

	set->writeEntry("mplayer_bin", mplayer_bin);
	set->writeEntry("use_fontconfig", use_fontconfig);
	set->writeEntry("font_file", font_file);
	set->writeEntry("font_name", font_name);
	set->writeEntry("font_autoscale", font_autoscale);
	set->writeEntry("font_textscale", font_textscale);
	set->writeEntry("subcp", subcp);
	set->writeEntry("use_ass_subtitles", use_ass_subtitles);
	set->writeEntry("autoload_sub", autoload_sub);
	set->writeEntry("subfuzziness", subfuzziness);
	set->writeEntry("ass_color", (int) ass_color);
	set->writeEntry("ass_border_color", (int) ass_border_color);
	set->writeEntry("ass_styles", ass_styles);

	set->writeEntry("osd", osd);
	set->writeEntry("vo", vo);
	set->writeEntry("ao", ao);

	set->writeEntry("color_key", QString::number(color_key,16));

	set->writeEntry("audio_change_requires_restart", audio_change_requires_restart);
	set->writeEntry("fast_chapter_change", fast_chapter_change);

	set->writeEntry("dvd_device", dvd_device);
	set->writeEntry("cdrom_device", cdrom_device);

	set->writeEntry("use_cache", use_cache);
	set->writeEntry("cache", cache);
	set->writeEntry("use_mplayer_window", use_mplayer_window);

	set->writeEntry("monitor_aspect", monitor_aspect);

	set->writeEntry("latest_dir", latest_dir);
	set->writeEntry("last_url", last_url);
	set->writeEntry("last_dvd_directory", last_dvd_directory);

	set->writeEntry("mplayer_verbose", mplayer_verbose);
	set->writeEntry("resize_method", resize_method);
	set->writeEntry("disable_screensaver", disable_screensaver);

	set->writeEntry("screenshot_directory", screenshot_directory);
	set->writeEntry("subtitles_on_screenshots", subtitles_on_screenshots);

	set->writeEntry("use_soft_video_eq", use_soft_video_eq);
	set->writeEntry("use_soft_vol", use_soft_vol);
	set->writeEntry("use_volnorm", use_volnorm);
	set->writeEntry("softvol_max", softvol_max);


	set->writeEntry("audio_lang", audio_lang);
	set->writeEntry("subtitle_lang", subtitle_lang);

	set->writeEntry("use_hwac3", use_hwac3 );

	set->writeEntry("vcd_initial_title", vcd_initial_title);

	set->writeEntry("initial_volume", initial_volume);
	set->writeEntry("initial_contrast", initial_contrast);
	set->writeEntry("initial_brightness", initial_brightness);
	set->writeEntry("initial_hue", initial_hue);
	set->writeEntry("initial_saturation", initial_saturation);
	set->writeEntry("initial_gamma", initial_gamma);

	set->writeEntry("initial_panscan_factor", initial_panscan_factor);
	set->writeEntry("initial_sub_pos", initial_sub_pos);

	set->writeEntry("mplayer_additional_options", mplayer_additional_options);
	set->writeEntry("mplayer_additional_video_filters", mplayer_additional_video_filters);
	set->writeEntry("mplayer_additional_audio_filters", mplayer_additional_audio_filters);

	set->writeEntry("priority", priority);
	set->writeEntry("frame_drop", frame_drop);
	set->writeEntry("hard_frame_drop", hard_frame_drop);
	set->writeEntry("autosync", autosync);
	set->writeEntry("autosync_factor", autosync_factor);

	set->writeEntry("dont_remember_media_settings", dont_remember_media_settings);
	set->writeEntry("dont_remember_time_pos", dont_remember_time_pos);

#if STYLE_SWITCHING
	set->writeEntry("style", style);
#endif

	set->writeEntry("fullscreen", fullscreen);
	set->writeEntry("start_in_fullscreen", start_in_fullscreen);

	set->writeEntry("compact_mode", compact_mode);
	set->writeEntry("stay_on_top", stay_on_top);
	set->writeEntry("size_factor", size_factor);

	set->writeEntry("show_frame_counter", show_frame_counter);

	set->writeEntry("use_postprocessing", use_postprocessing);
	set->writeEntry("autoq", autoq);

	set->writeEntry("loop", loop);

	set->writeEntry("use_single_instance", use_single_instance);
	set->writeEntry("connection_port", connection_port);

	set->writeEntry("mouse_left_click_function", mouse_left_click_function);
	set->writeEntry("mouse_double_click_function", mouse_double_click_function);
	set->writeEntry("wheel_function", wheel_function);

	set->writeEntry("recents_max_items", recents_max_items);

	set->writeEntry("seeking1", seeking1);
	set->writeEntry("seeking2", seeking2);
	set->writeEntry("seeking3", seeking3);
	set->writeEntry("seeking4", seeking4);

	set->writeEntry("log_mplayer", log_mplayer);
	set->writeEntry("log_smplayer", log_smplayer);
	set->writeEntry("log_filter", log_filter);

	set->writeEntry("language", language);
	set->writeEntry("iconset", iconset);

	set->writeEntry("always_clear_background", always_clear_background);

	set->writeEntry("rx_endoffile", rx_endoffile);
	set->writeEntry("rx_novideo", rx_novideo);

	set->writeEntry("balloon_count", balloon_count);

	set->writeEntry("dont_use_eq_options", dont_use_eq_options);

	set->writeEntry("use_subfont", use_subfont);

	set->endGroup();
}

void Preferences::load() {
	qDebug("Preferences::load");

	QSettings * set = settings;

	set->beginGroup( "preferences");

	mplayer_bin = set->readEntry("mplayer_bin", mplayer_bin);

	use_fontconfig = set->readBoolEntry("use_fontconfig", use_fontconfig);
	font_file = set->readEntry("font_file", font_file);
	font_name = set->readEntry("font_name", font_name);
	font_autoscale = set->readNumEntry("font_autoscale", font_autoscale);
	font_textscale = set->readNumEntry("font_textscale", font_textscale);
	subcp = set->readEntry("subcp", subcp);
	subfuzziness = set->readNumEntry("subfuzziness", subfuzziness);
	use_ass_subtitles = set->readBoolEntry("use_ass_subtitles", use_ass_subtitles);
	autoload_sub = set->readBoolEntry("autoload_sub", autoload_sub);
	ass_color = set->readNumEntry("ass_color", ass_color);
	ass_border_color = set->readNumEntry("ass_border_color", ass_border_color);
	ass_styles = set->readEntry("ass_styles", ass_styles);

	osd = set->readNumEntry("osd", osd);
	vo = set->readEntry("vo", vo);
	ao = set->readEntry("ao", ao);

	bool ok;
	QString color = set->readEntry("color_key", QString::number(color_key,16));
	unsigned int temp_color_key = color.toUInt(&ok, 16);
	if (ok)
		color_key = temp_color_key;
	//color_key = set->readNumEntry("color_key", color_key);

	audio_change_requires_restart = set->readBoolEntry("audio_change_requires_restart", audio_change_requires_restart);
	fast_chapter_change = set->readBoolEntry("fast_chapter_change", fast_chapter_change);

	dvd_device = set->readEntry("dvd_device", dvd_device);
	cdrom_device = set->readEntry("cdrom_device", cdrom_device);

	use_cache = set->readBoolEntry("use_cache", use_cache);
	cache = set->readNumEntry("cache", cache);
	use_mplayer_window = set->readBoolEntry("use_mplayer_window", use_mplayer_window);

	monitor_aspect = set->readEntry("monitor_aspect", monitor_aspect);
		
	latest_dir = set->readEntry("latest_dir", latest_dir);
	last_url = set->readEntry("last_url", last_url);
	last_dvd_directory = set->readEntry("last_dvd_directory", last_dvd_directory);

	mplayer_verbose = set->readEntry("mplayer_verbose", mplayer_verbose);
	resize_method = set->readNumEntry("resize_method", resize_method);
	disable_screensaver = set->readBoolEntry("disable_screensaver", disable_screensaver);

	screenshot_directory = set->readEntry("screenshot_directory", screenshot_directory);
	subtitles_on_screenshots = set->readBoolEntry("subtitles_on_screenshots", subtitles_on_screenshots);

	use_soft_video_eq = set->readBoolEntry("use_soft_video_eq", use_soft_video_eq);
	use_soft_vol = set->readBoolEntry("use_soft_vol", use_soft_vol);
	use_volnorm = set->readBoolEntry("use_volnorm", use_volnorm);
	softvol_max = set->readNumEntry("softvol_max", softvol_max);

	audio_lang = set->readEntry("audio_lang", audio_lang);
	subtitle_lang = set->readEntry("subtitle_lang", subtitle_lang);

	use_hwac3 = set->readBoolEntry("use_hwac3", use_hwac3 );

	vcd_initial_title = set->readNumEntry("vcd_initial_title", vcd_initial_title );

	initial_volume = set->readNumEntry("initial_volume", initial_volume);
	initial_contrast = set->readNumEntry("initial_contrast", initial_contrast);
	initial_brightness = set->readNumEntry("initial_brightness", initial_brightness);
	initial_hue = set->readNumEntry("initial_hue", initial_hue);
	initial_saturation = set->readNumEntry("initial_saturation", initial_saturation);
	initial_gamma = set->readNumEntry("initial_gamma", initial_gamma);

	initial_panscan_factor = set->readDoubleEntry("initial_panscan_factor", initial_panscan_factor);
	initial_sub_pos = set->readNumEntry("initial_sub_pos", initial_sub_pos);

	mplayer_additional_options = set->readEntry("mplayer_additional_options", mplayer_additional_options);
	mplayer_additional_video_filters = set->readEntry("mplayer_additional_video_filters", mplayer_additional_video_filters);
	mplayer_additional_audio_filters = set->readEntry("mplayer_additional_audio_filters", mplayer_additional_audio_filters);

	priority = set->readNumEntry("priority", priority);
	frame_drop = set->readBoolEntry("frame_drop", frame_drop);
	hard_frame_drop = set->readBoolEntry("hard_frame_drop", hard_frame_drop);
	autosync = set->readBoolEntry("autosync", autosync);
	autosync_factor = set->readNumEntry("autosync_factor", autosync_factor);

	dont_remember_media_settings = set->readBoolEntry("dont_remember_media_settings", dont_remember_media_settings);
	dont_remember_time_pos = set->readBoolEntry("dont_remember_time_pos", dont_remember_time_pos);

#if STYLE_SWITCHING
	style = set->readEntry("style", style);
#endif

	fullscreen = set->readBoolEntry("fullscreen", fullscreen);
	start_in_fullscreen = set->readBoolEntry("start_in_fullscreen", start_in_fullscreen);

	compact_mode = set->readBoolEntry("compact_mode", compact_mode);
	stay_on_top = set->readBoolEntry("stay_on_top", stay_on_top);
	size_factor = set->readNumEntry("size_factor", size_factor);

	show_frame_counter = set->readBoolEntry("show_frame_counter", show_frame_counter);

	use_postprocessing = set->readBoolEntry("use_postprocessing", use_postprocessing);
	autoq = set->readNumEntry("autoq", autoq);

	loop = set->readBoolEntry("loop", loop);

	use_single_instance = set->readBoolEntry("use_single_instance", use_single_instance);
	connection_port = set->readNumEntry("connection_port", connection_port);

	mouse_left_click_function = set->readEntry("mouse_left_click_function", mouse_left_click_function);
	mouse_double_click_function = set->readEntry("mouse_double_click_function", mouse_double_click_function);
	wheel_function = set->readNumEntry("wheel_function", wheel_function);

	recents_max_items = set->readNumEntry("recents_max_items", recents_max_items);

	seeking1 = set->readNumEntry("seeking1", seeking1);
	seeking2 = set->readNumEntry("seeking2", seeking2);
	seeking3 = set->readNumEntry("seeking3", seeking3);
	seeking4 = set->readNumEntry("seeking4", seeking4);

	language = set->readEntry("language", language);
	iconset= set->readEntry("iconset", iconset);

	log_mplayer = set->readBoolEntry("log_mplayer", log_mplayer);
	log_smplayer = set->readBoolEntry("log_smplayer", log_smplayer);
	log_filter = set->readEntry("log_filter", log_filter);

	always_clear_background = set->readBoolEntry("always_clear_background", always_clear_background);

	rx_endoffile = set->readEntry("rx_endoffile", rx_endoffile);
	rx_novideo = set->readEntry("rx_novideo", rx_novideo);

	balloon_count = set->readNumEntry("balloon_count", balloon_count);

	dont_use_eq_options = set->readBoolEntry("dont_use_eq_options", dont_use_eq_options);

	use_subfont = set->readBoolEntry("use_subfont", use_subfont);

	set->endGroup();

	QFileInfo fi(mplayer_bin);
	if (fi.exists()) {
		mplayer_bin = fi.absFilePath();
		qDebug("mplayer_bin: '%s'", mplayer_bin.utf8().data());
	}
}

double Preferences::monitor_aspect_double() {
	qDebug("Preferences::monitor_aspect_double");

	QRegExp exp("(\\d+)[:/](\\d+)");
	if (exp.search( monitor_aspect ) != -1) {
		int w = exp.cap(1).toInt();
		int h = exp.cap(2).toInt();
		qDebug(" monitor_aspect parsed successfully: %d:%d", w, h);
		return (double) w/h;
	}

	bool ok;
	double res = monitor_aspect.toDouble(&ok);
	if (ok) {
		qDebug(" monitor_aspect parsed successfully: %f", res);
		return res;
	} else {
		qDebug(" warning: monitor_aspect couldn't be parsed!");
        qDebug(" monitor_aspect set to 0");
		return 0;
	}
}
