
#include "seekwidget.h"
#include <qlabel.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>

SeekWidget::SeekWidget( QWidget* parent, const char* name, WFlags fl)
	: SeekWidgetBase(parent,name,fl)
{
	time_edit->setDisplay(QTimeEdit::Minutes | QTimeEdit::Seconds);
}

SeekWidget::~SeekWidget() {
}

void SeekWidget::setIcon(QPixmap icon) {
	_image->setText("");
	_image->setPixmap(icon);
}

const QPixmap * SeekWidget::icon() const {
	return _image->pixmap();
}

void SeekWidget::setLabel(QString text) {
	_label->setText(text);
}

QString SeekWidget::label() const {
	return _label->text();
}

void SeekWidget::setTime(int secs) {
	QTime t;
	time_edit->setTime(t.addSecs(secs));
}

int SeekWidget::time() const {
	QTime t = time_edit->time();
	return (t.minute() * 60) + t.second();
}

void SeekWidget::languageChange() {
}
