/*  smplayer, GUI front-end for mplayer.
    Copyright (C) 2007 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* This file is based on the "small client-server example" from Qt */
/* Copyright (C) 1992-2000 Trolltech AS. */


#ifndef _SERVER_H_
#define _SERVER_H_

#include <qsocket.h>
#include <qserversocket.h>
#include <qstringlist.h>

/*
  The ClientSocket class provides a socket that is connected with a client.
  For every client that connects to the server, the server creates a new
  instance of this class.
*/

class ClientSocket : public QSocket
{
	Q_OBJECT

public:
	ClientSocket( int sock, QObject *parent=0, const char *name=0 );
	~ClientSocket();

	void sendText(QString text);

	void setActionsList(QStringList l) { actions_list = l; };
	QStringList actionsList() { return actions_list; };

signals:
	void receivedOpen(QString);
	void receivedOpenFiles(QStringList);
	void receivedFunction(QString);

private slots:
	void readClient();

private:
	QStringList actions_list;
	QStringList files_to_open;
};


/*
  The SimpleServer class handles new connections to the server. For every
  client that connects, it creates a new ClientSocket -- that instance is now
  responsible for the communication with that client.
*/
class MyServer : public QServerSocket
{
	Q_OBJECT

public:
	MyServer( Q_UINT16 port, QObject* parent=0 );
	~MyServer();

	void setActionsList(QStringList l) { actions_list = l; };
	QStringList actionsList() { return actions_list; };

signals:
	void newConnect( ClientSocket* );
	void receivedOpen(QString);
	void receivedOpenFiles(QStringList);
	void receivedFunction(QString);

protected:
	void newConnection( int socket );

private:
	QStringList actions_list;
};

#endif
