

#include "soundkonverterapp.h"

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("soundKonverter is a frontend to various sound en- and decoding programs.");

static const char version[] = "0.2 beta2";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Audio file(s) to open" ), 0 },
    { "replaygain", I18N_NOOP("Open the ReplayGain tool an add all given files"), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("soundkonverter", I18N_NOOP("soundKonverter"), version, description,
        KAboutData::License_GPL, "(C) 2005 Daniel Faust", 0, 0, "daniel@kaligames.de");
    about.addAuthor( "Daniel Faust", 0, "daniel@kaligames.de", "http://kaligames.de" );
    about.addCredit( "David Vignoni", "Nuvola icon theme", 0, "http://www.icon-king.com" );
    about.addCredit( "Scott Wheeler", "TagLib", "wheeler@kde.org", "http://ktown.kde.org/~wheeler" );
    //about.addCredit( "Michael Smith", "oggenc", "msmith@xiph.org" );
    //about.addCredit( "Josh Coalson", "flac" );
    //about.addCredit( "Lame Developers", "lame", "http://lame.sourceforge.net" );
    //about.addCredit( "FFMPEG Developers", "ffmpeg", "http://ffmpeg.sourceforge.net" );
    //about.addCredit( "MPlayer Developers", "mplayer", "http://www.mplayerhq.hu" );
    //about.addCredit( "Matthew T. Ashland", "mac", "http://www.monkeysaudio.com" );
    //about.addCredit( "The Musepack Development Team", "mppenc & mppdec", "http://www.musepack.net" );
    about.addCredit( "All Programmers of audioconverters", "Backends" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    soundKonverterApp::addCmdLineOptions();
    if( !soundKonverterApp::start() ) {
        return 0;
    }

    soundKonverterApp app;

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

/*
ofs{OptimFROG Dualstream generates two files, a lossy comressed *.ofs file and a correction file (*.ofc). With both files you can regenerate the original file. (currently not supported by soundKonverter, sorry.)}

*/

