

#ifndef _OPTIONS_SIMPLE_H_
#define _OPTIONS_SIMPLE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class QComboBox;
class KPushButton;
class QStringList;

/**
 * @short Options simple
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class OptionsSimple : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    OptionsSimple( QWidget *parent=0, const char *name=0, int text=0 );

    QComboBox *cProfile;
    QStringList sProfile;
    KPushButton *pProfileInfo;
    QComboBox *cFormat;
    QStringList sFormat;
    KPushButton *pFormatInfo;

    int profileIndex( QString string );
    int formatIndex( QString string );

    /**
     * Default Destructor
     */
    virtual ~OptionsSimple();

public slots:
    void profileInfo();
    void formatInfo();
    void profileChanged();
    void formatChanged();

signals:
    void setFormat( QString format );
    void setQualityMode( QString qualityMode );
    void setQuality( int quality );
    void setBitrateRange( bool enabled );
    void setResample( bool enabled );
    void setSampleRate( int sampleRate );
    void setChannels( bool enabled );
    void setNumChannels( QString channels );

};

#endif // _OPTIONS_SIMPLE_H_
