/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model;

import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;

public abstract class AbstractModelElement
implements IModelElement {
    private IModelElement parent;
    private String name;

    protected AbstractModelElement(IModelElement parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IModelElement) {
            return this.getElementID().equals(((IModelElement)obj).getElementID());
        }
        return false;
    }

    public final int hashCode() {
        return this.getElementID().hashCode();
    }

    public final void setElementParent(IModelElement parent) {
        this.parent = parent;
    }

    public final IModelElement getElementParent() {
        return this.parent;
    }

    public IModelElement[] getElementChildren() {
        return NO_CHILDREN;
    }

    public final void setElementName(String name) {
        this.name = name;
    }

    public final String getElementName() {
        return this.name;
    }

    public final String getElementID() {
        StringBuffer id = new StringBuffer();
        if (this.getElementParent() != null) {
            id.append(this.getElementParent().getElementID());
            id.append('|');
        }
        id.append(this.getElementType());
        id.append(':');
        if (this.getElementName() != null) {
            id.append(this.getElementName());
        } else {
            id.append(this.hashCode());
        }
        return id.toString();
    }

    public void accept(IModelElementVisitor visitor) {
        visitor.visit(this);
    }

    public final IModelElement getElement(String id) {
        int sepPos = id.indexOf(58);
        if (sepPos > 0) {
            try {
                int type = Integer.valueOf(id.substring(0, sepPos));
                if (type == this.getElementType()) {
                    int delPos = id.indexOf(124);
                    if (delPos > 0) {
                        String name = id.substring(sepPos + 1, delPos);
                        if (name.equals(this.getElementName())) {
                            id = id.substring(delPos + 1);
                            IModelElement[] children = this.getElementChildren();
                            int i = 0;
                            while (i < children.length) {
                                IModelElement element;
                                IModelElement child = children[i];
                                if (child instanceof AbstractModelElement && (element = ((AbstractModelElement)child).getElement(id)) != null) {
                                    return element;
                                }
                                ++i;
                            }
                        }
                    } else {
                        String name = id.substring(sepPos + 1);
                        if (name.equals(this.getElementName())) {
                            return this;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }
}

