/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.ImageDescriptorRegistry;

public class BeansUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.ui";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.beans.ui.messages";
    private static BeansUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private ImageDescriptorRegistry imageDescriptorRegistry;

    public BeansUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            BeansUIPlugin.log(e);
            this.resourceBundle = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.imageDescriptorRegistry != null) {
            this.imageDescriptorRegistry.dispose();
        }
        super.stop(context);
    }

    protected ImageRegistry createImageRegistry() {
        return BeansUIImages.getImageRegistry();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return BeansUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public static BeansUIPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return BeansUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return BeansUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return BeansUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = BeansUIPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                BeansUIPlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public static String getFormattedMessage(String key, String arg) {
        return BeansUIPlugin.getFormattedMessage(key, new String[]{arg});
    }

    public static String getFormattedMessage(String key, String[] args) {
        return MessageFormat.format(BeansUIPlugin.getResourceString(key), args);
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        BeansUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = BeansUIPlugin.createErrorStatus(message, exception);
        BeansUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        BeansUIPlugin.getDefault().getLog().log(BeansUIPlugin.createErrorStatus(BeansUIPlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }
}

