/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.properties.ChildBeanProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.ConfigSetProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.ConstructorArgumentProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.PropertyProperties;
import org.springframework.ide.eclipse.beans.ui.model.properties.RootBeanProperties;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewLocation;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeansUIUtils {
    public static final IFile getConfigFile(IEditorPart editor) {
        IEditorInput input;
        if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
            if (project != null && project.hasConfig(file)) {
                return file;
            }
        }
        return null;
    }

    public static final IPropertySource getPropertySource(String id) {
        IModelElement element = BeansCorePlugin.getModel().getElement(id);
        return element != null ? BeansUIUtils.getPropertySource(element) : null;
    }

    public static final IPropertySource getPropertySource(IModelElement element) {
        if (element instanceof IBeansProject) {
            return new ResourcePropertySource((IResource)((IBeansProject)element).getProject());
        }
        if (element instanceof IBeansConfig) {
            IFile file = ((IBeansConfig)element).getConfigFile();
            if (file != null && file.exists()) {
                return new FilePropertySource(file);
            }
        } else {
            if (element instanceof IBeansConfigSet) {
                return new ConfigSetProperties((IBeansConfigSet)element);
            }
            if (element instanceof IBean) {
                IBean bean = (IBean)element;
                if (bean.isRootBean()) {
                    return new RootBeanProperties(bean);
                }
                return new ChildBeanProperties(bean);
            }
            if (element instanceof IBeanConstructorArgument) {
                return new ConstructorArgumentProperties((IBeanConstructorArgument)element);
            }
            if (element instanceof IBeanProperty) {
                return new PropertyProperties((IBeanProperty)element);
            }
        }
        return null;
    }

    public static final BeansViewLocation getBeansViewLocation(String elementID) {
        IBeansModel model = BeansCorePlugin.getModel();
        return BeansUIUtils.getBeansViewLocation(model.getElement(elementID));
    }

    public static final BeansViewLocation getBeansViewLocation(IModelElement element) {
        BeansViewLocation location = new BeansViewLocation();
        if (element instanceof IBeansProject) {
            location.setProjectName(element.getElementName());
        } else if (element instanceof IBeansConfigSet) {
            location.setProjectName(element.getElementParent().getElementName());
            location.setConfigSetName(element.getElementName());
        } else if (element instanceof IBeansConfig) {
            location.setProjectName(element.getElementParent().getElementName());
            location.setConfigName(element.getElementName());
        } else if (element instanceof IBean) {
            location.setProjectName(element.getElementParent().getElementParent().getElementName());
            location.setConfigName(element.getElementParent().getElementName());
            location.setBeanName(element.getElementName());
        } else if (element instanceof IBeanProperty) {
            location.setProjectName(element.getElementParent().getElementParent().getElementParent().getElementName());
            location.setConfigName(element.getElementParent().getElementParent().getElementName());
            location.setBeanName(element.getElementParent().getElementName());
            location.setPropertyName(element.getElementName());
        }
        return location;
    }
}

