/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescription;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionHandler;
import org.springframework.ide.eclipse.beans.core.internal.project.BeansProjectDescriptionWriter;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUILabelDecorator;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MigrateSpringUIProject
implements IObjectActionDelegate {
    private static final String SPRINGUI_CORE_PLUGIN_ID = "org.springframework.eclipse.core";
    private static final String SPRINGUI_NATURE_ID = "org.springframework.eclipse.core.springnature";
    private static final String SPRINGUI_BUILDER_ID = "org.springframework.eclipse.core.springvalidator";
    private static final String SPRINGUI_MARKER_ID = "org.springframework.eclipse.core.problemmarker";
    private static final String SPRINGUI_PROJECT_DESCRIPTION = ".springProject";
    private List selected = new ArrayList();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    public void run(IAction action) {
        Iterator iter = this.selected.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            this.migrateProject(project);
        }
        BeansUILabelDecorator.update();
    }

    private void migrateProject(IProject project) {
        SpringCoreUtils.removeProjectBuilder((IProject)project, (String)SPRINGUI_BUILDER_ID);
        SpringCoreUtils.removeProjectNature((IProject)project, (String)SPRINGUI_NATURE_ID);
        IFile file = project.getFile((IPath)new Path(SPRINGUI_PROJECT_DESCRIPTION));
        if (file.isAccessible()) {
            BeansProjectDescription description = this.read(file);
            if (description != null) {
                this.deleteProblemMarkers(project, description);
                BeansProjectDescriptionWriter.write((IProject)project, (BeansProjectDescription)description);
            }
            try {
                file.delete(true, null);
            }
            catch (CoreException e) {
                BeansUIPlugin.log(e);
            }
        }
        SpringCoreUtils.addProjectNature((IProject)project, (String)"org.springframework.ide.eclipse.core.springnature");
    }

    private void deleteProblemMarkers(IProject project, BeansProjectDescription description) {
        Iterator iter = description.getConfigNames().iterator();
        while (iter.hasNext()) {
            IFile file = project.getFile((IPath)new Path((String)iter.next()));
            if (!file.isAccessible()) continue;
            try {
                file.deleteMarkers(SPRINGUI_MARKER_ID, false, 0);
            }
            catch (CoreException e) {
                BeansUIPlugin.log(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private BeansProjectDescription read(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [7 : 231->234)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class SpringUIProjectDescriptionHandler
    extends BeansProjectDescriptionHandler {
        public String PROJECT_DESCRIPTION = "springProjectDescription";

        public SpringUIProjectDescriptionHandler(IBeansProject project) {
            super(project);
        }

        public void startElement(String uri, String elementName, String qname, Attributes attributes) throws SAXException {
            this.charBuffer.setLength(0);
            switch (this.state) {
                case 0: {
                    if (elementName.equals(this.PROJECT_DESCRIPTION)) {
                        this.state = 1;
                        this.description = new BeansProjectDescription(this.project);
                        break;
                    }
                    throw new SAXParseException("No Spring project description", this.locator);
                }
                default: {
                    super.startElement(uri, elementName, qname, attributes);
                }
            }
        }
    }
}

