/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.AbstractNode;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class ConfigSetNode
extends AbstractNode {
    public static final int NAME = 1;
    public static final int CONFIGS = 2;
    private List configs = new ArrayList();
    private List beans = null;
    private Map beansMap;
    private boolean isOverrideEnabled = false;
    private boolean isIncomplete = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConfigSetNode(ProjectNode project) {
        super(project, null);
    }

    public ConfigSetNode(ProjectNode project, IBeansConfigSet configSet) {
        super(project, configSet.getElementName());
        this.setElement((IModelElement)configSet);
        this.isOverrideEnabled = configSet.isAllowBeanDefinitionOverriding();
        Iterator iter = configSet.getConfigs().iterator();
        while (iter.hasNext()) {
            String configName = (String)iter.next();
            ConfigNode config = new ConfigNode(this, configName);
            this.configs.add(config);
        }
    }

    public ProjectNode getProjectNode() {
        return (ProjectNode)this.getParent();
    }

    public void setName(String name) {
        super.setName(name);
        this.propertyChanged(this, 1);
    }

    public IBeansConfigSet getConfigSet() {
        return (IBeansConfigSet)this.getElement();
    }

    public void setOverrideEnabled(boolean isOverrideEnabled) {
        this.isOverrideEnabled = isOverrideEnabled;
    }

    public boolean isOverrideEnabled() {
        return this.isOverrideEnabled;
    }

    public void setIncomplete(boolean isIncomplete) {
        this.isIncomplete = isIncomplete;
    }

    public boolean isIncomplete() {
        return this.isIncomplete;
    }

    public void addConfig(ConfigNode config) {
        this.configs.add(config);
        this.propertyChanged(this, 2);
    }

    public int getConfigCount() {
        return this.configs.size();
    }

    public List getConfigs() {
        return new ArrayList(this.configs);
    }

    public List getConfigNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator iter = this.configs.iterator();
        while (iter.hasNext()) {
            ConfigNode config = (ConfigNode)iter.next();
            names.add(config.getName());
        }
        return names;
    }

    public boolean hasConfig(String name) {
        Iterator iter = this.configs.iterator();
        while (iter.hasNext()) {
            ConfigNode config = (ConfigNode)iter.next();
            if (!name.equals(config.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeConfig(String name) {
        ConfigNode removeConfig = null;
        Iterator iter = this.configs.iterator();
        while (iter.hasNext()) {
            ConfigNode config = (ConfigNode)iter.next();
            if (!name.equals(config.getName())) continue;
            removeConfig = config;
            break;
        }
        if (removeConfig != null) {
            this.configs.remove(removeConfig);
            this.propertyChanged(this, 2);
        }
    }

    public void moveConfigUp(ConfigNode config) {
        int index = this.configs.indexOf(config);
        if (index > 0) {
            this.configs.remove(config);
            this.configs.add(index - 1, config);
            this.propertyChanged(this, 2);
        }
    }

    public void moveConfigDown(ConfigNode config) {
        int index = this.configs.indexOf(config);
        if (index != -1 && index < this.configs.size() - 1) {
            this.configs.remove(config);
            this.configs.add(index + 1, config);
            this.propertyChanged(this, 2);
        }
    }

    public BeanNode getBean(String name) {
        if (this.beansMap == null) {
            if (this.beans == null) {
                this.readConfigFiles();
                this.refreshViewer();
            }
            this.beansMap = new HashMap();
            Iterator iter = this.beans.iterator();
            while (iter.hasNext()) {
                BeanNode bean = (BeanNode)iter.next();
                this.beansMap.put(bean.getName(), bean);
            }
        }
        return (BeanNode)this.beansMap.get(name);
    }

    public BeanNode[] getBeans(boolean refreshViewer) {
        if (this.beans == null) {
            this.readConfigFiles();
            if (refreshViewer) {
                this.refreshViewer();
            }
        }
        return this.beans.toArray(new BeanNode[this.beans.size()]);
    }

    private void readConfigFiles() {
        this.beans = new ArrayList();
        Iterator iter = this.configs.iterator();
        while (iter.hasNext()) {
            ConfigNode config = (ConfigNode)iter.next();
            BeanNode[] beans = config.getBeans(false);
            int i = 0;
            while (i < beans.length) {
                BeanNode bean = new BeanNode(this, beans[i]);
                this.markOverridingBean(bean);
                this.beans.add(bean);
                ++i;
            }
        }
    }

    private void markOverridingBean(BeanNode newBean) {
        String beanName = newBean.getName();
        Iterator iter = this.beans.iterator();
        while (iter.hasNext()) {
            BeanNode bean = (BeanNode)iter.next();
            if ((bean.getFlags() & 2) != 0 || !beanName.equals(bean.getName())) continue;
            newBean.setIsOverride(true);
            break;
        }
    }

    public void clear() {
        this.configs.clear();
        if (this.beans != null) {
            this.beans.clear();
        }
    }

    public void remove(INode node) {
        this.configs.remove(node);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return BeansUIUtils.getPropertySource((IModelElement)this.getConfigSet());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.ide.eclipse.core.model.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getConfigSet();
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getName());
        text.append(": configs=");
        text.append(this.configs);
        return text.toString();
    }
}

