/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUILabelDecorator;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigFilesBlock;
import org.springframework.ide.eclipse.beans.ui.properties.ConfigSetsBlock;

public class ConfigurationPropertyPage
extends PropertyPage {
    public static final String ID = "org.springframework.ide.eclipse.beans.ui.properties.ConfigurationPropertyPage";
    private static final String TITLE = "ConfigurationPropertyPage.title";
    private static final String CONFIG_FILES_LABEL = "ConfigurationPropertyPage.tabConfigFiles.label";
    private static final String CONFIG_SETS_LABEL = "ConfigurationPropertyPage.tabConfigSets.label";
    private ProjectNode projectModel;
    private ConfigFilesBlock configFilesBlock;
    private ConfigSetsBlock configSetsBlock;
    private int selectedBlock;

    public ConfigurationPropertyPage() {
        this(null, 0);
    }

    public ConfigurationPropertyPage(IProject project) {
        this(project, 0);
    }

    public ConfigurationPropertyPage(IProject project, int selectedBlock) {
        this.setElement((IAdaptable)project);
        this.setTitle(BeansUIPlugin.getResourceString(TITLE));
        this.noDefaultAndApplyButton();
        this.selectedBlock = selectedBlock;
    }

    protected Control createContents(Composite parent) {
        BeansProject project = this.getSpringProject();
        this.projectModel = new ProjectNode(null, project.getElementName());
        this.projectModel.setConfigs(project.getConfigNames());
        this.projectModel.setConfigSets(project.getConfigSets());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayoutData((Object)new GridData(1808));
        this.configFilesBlock = new ConfigFilesBlock(this.projectModel, this.getElement());
        TabItem item = new TabItem(folder, 0);
        item.setText(BeansUIPlugin.getResourceString(CONFIG_FILES_LABEL));
        item.setControl(this.configFilesBlock.createControl((Composite)folder));
        this.configSetsBlock = new ConfigSetsBlock(this.projectModel, this.getElement());
        item = new TabItem(folder, 0);
        item.setText(BeansUIPlugin.getResourceString(CONFIG_SETS_LABEL));
        item.setControl(this.configSetsBlock.createControl((Composite)folder));
        Dialog.applyDialogFont((Control)folder);
        folder.setSelection(this.selectedBlock);
        return folder;
    }

    public boolean performOk() {
        BeansProject project = this.getSpringProject();
        if (this.configFilesBlock.hasUserMadeChanges()) {
            project.setConfigs((Collection)this.projectModel.getConfigNames());
            BeansUILabelDecorator.update();
        }
        if (this.configSetsBlock.hasUserMadeChanges()) {
            ArrayList<BeansConfigSet> configSets = new ArrayList<BeansConfigSet>();
            Iterator iter = this.projectModel.getConfigSets().iterator();
            while (iter.hasNext()) {
                ConfigSetNode node = (ConfigSetNode)iter.next();
                BeansConfigSet configSet = new BeansConfigSet((IBeansProject)project, node.getName(), node.getConfigNames());
                configSet.setAllowBeanDefinitionOverriding(node.isOverrideEnabled());
                configSet.setIncomplete(node.isIncomplete());
                configSets.add(configSet);
            }
            project.setConfigSets(configSets);
        }
        return super.performOk();
    }

    protected BeansProject getSpringProject() {
        return (BeansProject)BeansCorePlugin.getModel().getProject((IProject)this.getElement());
    }

    public void dispose() {
        this.configFilesBlock.dispose();
        this.configSetsBlock.dispose();
        super.dispose();
    }
}

