/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.parts;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;
import org.springframework.ide.eclipse.beans.ui.graph.model.Reference;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class ReferencePart
extends AbstractConnectionEditPart {
    protected Reference getReference() {
        return (Reference)((Object)this.getModel());
    }

    protected IFigure createFigure() {
        PolylineConnection conn = this.createConnection(this.getReference());
        Label label = new Label();
        switch (this.getReference().getType()) {
            case 2: {
                conn.setLineStyle(3);
                label.setText("Parent bean: " + this.getReference().getTargetBean().getName());
                break;
            }
            case 3: {
                conn.setLineStyle(2);
                label.setText("Factory bean");
                break;
            }
            case 4: {
                conn.setLineStyle(2);
                label.setText("Depends-on bean");
                break;
            }
            case 5: {
                conn.setLineStyle(3);
                label.setText("Method-override bean");
                break;
            }
            case 6: {
                conn.setLineStyle(4);
                label.setText("Interceptor bean");
                break;
            }
            default: {
                Node node = this.getReference().getNode();
                if (node instanceof ConstructorArgument) {
                    label.setText("ConstructorArgument: " + ((ConstructorArgument)node).getName());
                    break;
                }
                if (!(node instanceof Property)) break;
                label.setText("Property: " + ((Property)node).getName());
            }
        }
        conn.setToolTip((IFigure)label);
        return conn;
    }

    protected void createEditPolicies() {
    }

    protected PolylineConnection createConnection(Edge edge) {
        NodeList nodes;
        PolylineConnection conn = new PolylineConnection();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
        Bean source = (Bean)this.getReference().source;
        if (source.height > source.preferredHeight) {
            Rectangle rect = new Rectangle(source.x + 10, source.y + 10, source.width, source.height);
            bends.add(new AbsoluteBendpoint(rect.getBottom()));
        }
        if ((nodes = edge.vNodes) != null) {
            int i = 0;
            while (i < nodes.size()) {
                Node node = nodes.getNode(i);
                if (edge.isFeedback) {
                    bends.add(new AbsoluteBendpoint(node.x + 10, node.y + 10 + node.height));
                    bends.add(new AbsoluteBendpoint(node.x + 10, node.y + 10));
                } else {
                    bends.add(new AbsoluteBendpoint(node.x + 10, node.y + 10));
                    bends.add(new AbsoluteBendpoint(node.x + 10, node.y + 10 + node.height));
                }
                ++i;
            }
        }
        conn.setRoutingConstraint(bends);
        conn.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        return conn;
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(1);
        }
    }

    public void performRequest(Request req) {
        if (req.getType() == "open") {
            SpringUIUtils.openInEditor((IFile)this.getReference().getConfigFile(), (int)this.getReference().getStartLine());
        }
        super.performRequest(req);
    }
}

