/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.model.AbstractSourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;

public class Bean
extends AbstractSourceModelElement
implements IBean {
    private BeanDefinitionHolder beanDefinitionHolder;
    private List constructorArguments = new ArrayList();
    private List properties = new ArrayList();
    private Map propertiesMap = new HashMap();
    private List innerBeans = new ArrayList();

    public Bean(IBeansConfig config) {
        super((IModelElement)config, null);
    }

    public int getElementType() {
        return 5;
    }

    public IModelElement[] getElementChildren() {
        ArrayList children = new ArrayList(this.getConstructorArguments());
        children.addAll(this.getProperties());
        children.addAll(this.getInnerBeans());
        return children.toArray(new IModelElement[children.size()]);
    }

    public IResource getElementResource() {
        if (this.getElementParent() instanceof IResourceModelElement) {
            return ((IResourceModelElement)this.getElementParent()).getElementResource();
        }
        return null;
    }

    public void accept(IModelElementVisitor visitor) {
        if (visitor.visit((IModelElement)this)) {
            IModelElement element;
            Iterator iter = this.constructorArguments.iterator();
            while (iter.hasNext()) {
                element = (IModelElement)iter.next();
                element.accept(visitor);
            }
            iter = this.properties.iterator();
            while (iter.hasNext()) {
                element = (IModelElement)iter.next();
                element.accept(visitor);
            }
            iter = this.innerBeans.iterator();
            while (iter.hasNext()) {
                element = (IModelElement)iter.next();
                element.accept(visitor);
            }
        }
    }

    public IBeansConfig getConfig() {
        IModelElement parent = this.getElementParent();
        if (parent instanceof IBeansConfig) {
            return (IBeansConfig)parent;
        }
        if (parent instanceof IBean) {
            return ((IBean)parent).getConfig();
        }
        if (parent instanceof IBeanProperty || parent instanceof IBeanConstructorArgument) {
            return ((IBean)parent.getElementParent()).getConfig();
        }
        throw new IllegalStateException("Unsupported parent element in bean '" + this.getElementName() + "'");
    }

    public void setBeanDefinitionHolder(BeanDefinitionHolder beanDefinitionHolder) {
        this.beanDefinitionHolder = beanDefinitionHolder;
        this.setElementName(beanDefinitionHolder.getBeanName());
    }

    public BeanDefinitionHolder getBeanDefinitionHolder() {
        return this.beanDefinitionHolder;
    }

    public String[] getAliases() {
        return this.beanDefinitionHolder.getAliases();
    }

    public void addConstructorArgument(IBeanConstructorArgument carg) {
        this.constructorArguments.add(carg);
    }

    public Collection getConstructorArguments() {
        return this.constructorArguments;
    }

    public void addProperty(IBeanProperty property) {
        this.properties.add(property);
        this.propertiesMap.put(property.getElementName(), property);
    }

    public IBeanProperty getProperty(String name) {
        if (name != null) {
            return (IBeanProperty)this.propertiesMap.get(name);
        }
        return null;
    }

    public Collection getProperties() {
        return this.properties;
    }

    public void addInnerBean(Bean bean) {
        this.innerBeans.add(bean);
    }

    public Collection getInnerBeans() {
        return this.innerBeans;
    }

    public String getClassName() {
        BeanDefinition beanDef = this.beanDefinitionHolder.getBeanDefinition();
        if (beanDef instanceof AbstractBeanDefinition) {
            return ((AbstractBeanDefinition)beanDef).getBeanClassName();
        }
        return null;
    }

    public String getParentName() {
        BeanDefinition beanDef = this.beanDefinitionHolder.getBeanDefinition();
        if (beanDef instanceof ChildBeanDefinition) {
            return ((ChildBeanDefinition)beanDef).getParentName();
        }
        return null;
    }

    public boolean isRootBean() {
        return this.beanDefinitionHolder.getBeanDefinition() instanceof RootBeanDefinition;
    }

    public boolean isSingleton() {
        BeanDefinition beanDef = this.beanDefinitionHolder.getBeanDefinition();
        if (beanDef instanceof RootBeanDefinition) {
            return ((RootBeanDefinition)beanDef).isSingleton();
        }
        if (beanDef instanceof ChildBeanDefinition) {
            return ((ChildBeanDefinition)beanDef).isSingleton();
        }
        return true;
    }

    public boolean isAbstract() {
        return this.beanDefinitionHolder.getBeanDefinition().isAbstract();
    }

    public boolean isLazyInit() {
        return this.beanDefinitionHolder.getBeanDefinition().isLazyInit();
    }

    public boolean isInnerBean() {
        return this.getElementParent() != null;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getElementName());
        text.append(" (");
        text.append(this.getElementStartLine());
        text.append(')');
        if (this.getClassName() != null) {
            text.append(" [");
            text.append(this.getClassName());
            text.append(']');
        } else if (this.getParentName() != null) {
            text.append(" <");
            text.append(this.getParentName());
            text.append('>');
        }
        return text.toString();
    }
}

